/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.DateConverter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CalendarConverter
implements Converter {
    public static final CalendarConverter INSTANCE = new CalendarConverter();

    CalendarConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Calendar.class.isAssignableFrom(cls);
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        String str;
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value instanceof Number) {
            Calendar cal = (Calendar)context.createInternal(c);
            cal.setTimeInMillis(((Number)value).longValue());
            return cal;
        }
        if (value != null && (str = value.toString().trim()).length() > 0) {
            Calendar cal = (Calendar)context.createInternal(c);
            DateFormat format = context.getDateFormat();
            if (format != null) {
                cal.setTime(format.parse(str));
            } else {
                cal.setTime(DateConverter.convertDate(context, str));
            }
            return cal;
        }
        return null;
    }
}

