/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.PlainConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BooleanConverter
implements Converter {
    public static final BooleanConverter INSTANCE = new BooleanConverter();

    BooleanConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Boolean.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof BigDecimal) {
            return !value.equals(BigDecimal.ZERO);
        }
        if (value instanceof BigInteger) {
            return !value.equals(BigInteger.ZERO);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        if (value != null) {
            String s = value.toString().trim();
            if (s.length() == 0 || s.equalsIgnoreCase("0") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("off") || s.equals("NaN")) {
                return false;
            }
            return true;
        }
        return PlainConverter.getDefaultValue(c);
    }
}

