/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.arnx.jsonic.util.ConstructorInfo;
import net.arnx.jsonic.util.MethodInfo;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanInfo {
    private static final Map<ClassLoader, Map<Class<?>, BeanInfo>> cache = new WeakHashMap();
    private Class<?> type;
    private ConstructorInfo ci;
    private Map<String, PropertyInfo> sprops;
    private Map<String, MethodInfo> smethods;
    private Map<String, PropertyInfo> props;
    private Map<String, MethodInfo> methods;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanInfo get(Class<?> clazz) {
        Map<ClassLoader, Map<Class<?>, BeanInfo>> map = cache;
        synchronized (map) {
            BeanInfo beanInfo = null;
            LinkedHashMap linkedHashMap = cache.get(clazz.getClassLoader());
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap<Class<?>, BeanInfo>(16, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Class<?>, BeanInfo> entry) {
                        return this.size() > 1024;
                    }
                };
                cache.put(clazz.getClassLoader(), linkedHashMap);
            } else {
                beanInfo = linkedHashMap.get(clazz);
            }
            if (beanInfo == null) {
                beanInfo = new BeanInfo(clazz);
                linkedHashMap.put(clazz, beanInfo);
            }
            return beanInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<ClassLoader, Map<Class<?>, BeanInfo>> map = cache;
        synchronized (map) {
            cache.clear();
        }
    }

    private BeanInfo(Class<?> clazz) {
        Class<?>[] classArray;
        this.type = clazz;
        for (Constructor<?> accessibleObject : clazz.getConstructors()) {
            if (accessibleObject.isSynthetic()) continue;
            if (this.ci == null) {
                this.ci = new ConstructorInfo(clazz, null);
            }
            accessibleObject.setAccessible(true);
            this.ci.constructors.add(accessibleObject);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (((Field)accessibleObject).isSynthetic() || ((Field)accessibleObject).getDeclaringClass() == Object.class || clazz == Class.class) continue;
            boolean bl = Modifier.isStatic(((Field)accessibleObject).getModifiers());
            classArray = ((Field)accessibleObject).getName();
            ((Field)accessibleObject).setAccessible(true);
            if (bl) {
                if (this.sprops == null) {
                    this.sprops = Collections.synchronizedMap(new LinkedHashMap());
                }
                this.sprops.put((String)classArray, new PropertyInfo(clazz, (String)classArray, (Field)accessibleObject, null, null, bl, -1));
                continue;
            }
            if (this.props == null) {
                this.props = Collections.synchronizedMap(new LinkedHashMap());
            }
            this.props.put((String)classArray, new PropertyInfo(clazz, (String)classArray, (Field)accessibleObject, null, null, bl, -1));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            Object object;
            boolean bl;
            MethodInfo methodInfo;
            if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
            String string = ((Method)accessibleObject).getName();
            classArray = ((Method)accessibleObject).getParameterTypes();
            Class<?> clazz2 = ((Method)accessibleObject).getReturnType();
            boolean bl2 = Modifier.isStatic(((Method)accessibleObject).getModifiers());
            if (bl2) {
                if (this.smethods == null) {
                    this.smethods = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((methodInfo = this.smethods.get(string)) == null) {
                    methodInfo = new MethodInfo(clazz, string, null, bl2);
                    this.smethods.put(string, methodInfo);
                }
            } else {
                if (this.methods == null) {
                    this.methods = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((methodInfo = this.methods.get(string)) == null) {
                    methodInfo = new MethodInfo(clazz, string, null, bl2);
                    this.methods.put(string, methodInfo);
                }
            }
            ((Method)accessibleObject).setAccessible(true);
            methodInfo.methods.add((Method)accessibleObject);
            if (((Method)accessibleObject).getDeclaringClass() == Object.class || clazz == Class.class) continue;
            int n = 0;
            if (string.startsWith("get") && classArray.length == 0 && !clazz2.equals(Void.TYPE)) {
                bl = true;
                n = 3;
            } else if (string.startsWith("is") && classArray.length == 0 && !clazz2.equals(Void.TYPE)) {
                bl = true;
                n = 2;
            } else {
                if (!string.startsWith("set") || classArray.length != 1 || classArray[0].equals(Void.TYPE)) continue;
                bl = false;
                n = 3;
            }
            if ((string.length() <= n || Character.isLowerCase(string.charAt(n))) && (string.length() <= n + 1 || Character.isLowerCase(string.charAt(n + 1)))) continue;
            if ((string = string.substring(n)).length() < 2 || !Character.isUpperCase(string.charAt(1))) {
                object = string.toCharArray();
                object[0] = Character.toLowerCase(object[0]);
                string = String.valueOf(object);
            }
            if (bl2) {
                if (this.sprops == null) {
                    this.sprops = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((object = (Object)this.sprops.get(string)) == null) {
                    object = new PropertyInfo(clazz, string, null, null, null, bl2, -1);
                    this.sprops.put(string, (PropertyInfo)object);
                }
            } else {
                if (this.props == null) {
                    this.props = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((object = (Object)this.props.get(string)) == null) {
                    object = new PropertyInfo(clazz, string, null, null, null, bl2, -1);
                    this.props.put(string, (PropertyInfo)object);
                }
            }
            if (bl) {
                object.readMethod = accessibleObject;
                continue;
            }
            object.writeMethod = accessibleObject;
        }
        if (this.sprops == null) {
            this.sprops = Collections.emptyMap();
        }
        if (this.smethods == null) {
            this.smethods = Collections.emptyMap();
        }
        if (this.props == null) {
            this.props = Collections.emptyMap();
        }
        if (this.methods == null) {
            this.methods = Collections.emptyMap();
        }
    }

    public Object newInstance() {
        try {
            Constructor<?> constructor = this.type.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public ConstructorInfo getConstructor() {
        return this.ci;
    }

    public PropertyInfo getStaticProperty(String string) {
        return this.sprops.get(string);
    }

    public MethodInfo getStaticMethod(String string) {
        return this.smethods.get(string);
    }

    public Collection<PropertyInfo> getStaticProperties() {
        return this.sprops.values();
    }

    public Collection<MethodInfo> getStaticMethods() {
        return this.smethods.values();
    }

    public PropertyInfo getProperty(String string) {
        return this.props.get(string);
    }

    public MethodInfo getMethod(String string) {
        return this.methods.get(string);
    }

    public Collection<PropertyInfo> getProperties() {
        return this.props.values();
    }

    public Collection<MethodInfo> getMethods() {
        return this.methods.values();
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BeanInfo beanInfo = (BeanInfo)object;
        return !(this.type == null ? beanInfo.type != null : !this.type.equals(beanInfo.type));
    }

    public String toString() {
        return "BeanInfo [static properties = " + this.sprops + ", static methods = " + this.smethods + ", properties = " + this.props + ", methods = " + this.methods + "]";
    }

    static int calcurateDistance(Class<?>[] classArray, Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                if (classArray[i].isPrimitive()) continue;
                n += 5;
                continue;
            }
            if (classArray[i].equals(objectArray[i].getClass())) {
                n += 10;
                continue;
            }
            if (classArray[i].isAssignableFrom(objectArray[i].getClass())) {
                n += 8;
                continue;
            }
            if (Boolean.TYPE == objectArray[i].getClass() || Boolean.class == objectArray[i].getClass()) {
                if (Boolean.TYPE != classArray[i] && Boolean.class != classArray[i]) continue;
                n += 10;
                continue;
            }
            if (Byte.TYPE == objectArray[i].getClass() || Byte.class == objectArray[i].getClass()) {
                if (Byte.TYPE != classArray[i] && Short.TYPE != classArray[i] && Character.TYPE != classArray[i] && Integer.TYPE != classArray[i] && Long.TYPE != classArray[i] && Float.TYPE != classArray[i] && Double.TYPE != classArray[i] && Byte.class != classArray[i] && Short.class != classArray[i] && Character.class != classArray[i] && Integer.class != classArray[i] && Long.class != classArray[i] && Float.class != classArray[i] && Double.class != classArray[i]) continue;
                n += 10;
                continue;
            }
            if (Short.TYPE == objectArray[i].getClass() || Short.class == objectArray[i].getClass() || Character.TYPE == objectArray[i].getClass() || Character.class == objectArray[i].getClass()) {
                if (Short.TYPE != classArray[i] && Character.TYPE != classArray[i] && Integer.TYPE != classArray[i] && Long.TYPE != classArray[i] && Float.TYPE != classArray[i] && Double.TYPE != classArray[i] && Short.class != classArray[i] && Character.class != classArray[i] && Integer.class != classArray[i] && Long.class != classArray[i] && Float.class != classArray[i] && Double.class != classArray[i]) continue;
                n += 10;
                continue;
            }
            if (Integer.TYPE == objectArray[i].getClass() || Integer.class == objectArray[i].getClass()) {
                if (Integer.TYPE != classArray[i] && Long.TYPE != classArray[i] && Float.TYPE != classArray[i] && Double.TYPE != classArray[i] && Integer.class != classArray[i] && Long.class != classArray[i] && Float.class != classArray[i] && Double.class != classArray[i]) continue;
                n += 10;
                continue;
            }
            if (Long.TYPE == objectArray[i].getClass() || Long.class == objectArray[i].getClass()) {
                if (Long.TYPE != classArray[i] && Float.TYPE != classArray[i] && Double.TYPE != classArray[i] && Long.class != classArray[i] && Float.class != classArray[i] && Double.class != classArray[i]) continue;
                n += 10;
                continue;
            }
            if (Float.TYPE == objectArray[i].getClass() || Float.class == objectArray[i].getClass()) {
                if (Float.TYPE != classArray[i] && Double.TYPE != classArray[i] && Float.class != classArray[i] && Double.class != classArray[i]) continue;
                n += 10;
                continue;
            }
            if (Double.TYPE != objectArray[i].getClass() && Double.class != objectArray[i].getClass() || Double.TYPE != classArray[i] && Double.class != classArray[i]) continue;
            n += 10;
        }
        return n;
    }
}

