/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONEventType;
import net.arnx.jsonic.io.InputSource;
import net.arnx.jsonic.parse.JSONParser;
import net.arnx.jsonic.parse.ScriptParser;
import net.arnx.jsonic.parse.TraditionalParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReader {
    private JSON.Context context;
    private JSONParser parser;
    private JSONEventType type;

    JSONReader(JSON.Context context, InputSource inputSource, boolean bl, boolean bl2) {
        this.context = context;
        switch (context.getMode()) {
            case STRICT: {
                this.parser = new JSONParser(inputSource, context.getMaxDepth(), bl, bl2, context.getLocalCache());
                break;
            }
            case SCRIPT: {
                this.parser = new ScriptParser(inputSource, context.getMaxDepth(), bl, bl2, context.getLocalCache());
                break;
            }
            default: {
                this.parser = new TraditionalParser(inputSource, context.getMaxDepth(), bl, bl2, context.getLocalCache());
            }
        }
    }

    public JSONEventType next() throws IOException {
        this.type = this.parser.next();
        return this.type;
    }

    public <T> T getValue(Class<T> clazz) throws IOException {
        return this.context.convertInternal(this.getValue(), clazz);
    }

    public Object getValue(Type type) throws IOException {
        return this.context.convertInternal(this.getValue(), type);
    }

    public Map<?, ?> getMap() throws IOException {
        return (Map)this.getValue();
    }

    public List<?> getList() throws IOException {
        return (List)this.getValue();
    }

    public String getString() throws IOException {
        return (String)this.parser.getValue();
    }

    public BigDecimal getNumber() throws IOException {
        return (BigDecimal)this.parser.getValue();
    }

    public Boolean getBoolean() throws IOException {
        return (Boolean)this.parser.getValue();
    }

    Object getValue() throws IOException {
        if (this.type == null) {
            throw new IllegalStateException("you should call next.");
        }
        int n = 0;
        int[] nArray = new int[8];
        int n2 = 0;
        Object[] objectArray = new Object[16];
        do {
            switch (this.type) {
                case START_OBJECT: 
                case START_ARRAY: {
                    nArray = this.iexpand(nArray, n + 1);
                    nArray[n++] = n2;
                    break;
                }
                case NAME: 
                case STRING: 
                case NUMBER: 
                case BOOLEAN: 
                case NULL: {
                    Object object = this.parser.getValue();
                    objectArray = this.oexpand(objectArray, n2 + 1);
                    objectArray[n2++] = object;
                    break;
                }
                case END_ARRAY: {
                    int n3;
                    int n4 = nArray[--n];
                    int n5 = n2 - n4;
                    Cloneable cloneable = new ArrayList(n5);
                    for (n3 = n4; n3 < n2; ++n3) {
                        cloneable.add(objectArray[n3]);
                    }
                    n2 = n4;
                    objectArray = this.oexpand(objectArray, n2 + 1);
                    objectArray[n2++] = cloneable;
                    break;
                }
                case END_OBJECT: {
                    int n3;
                    int n4 = nArray[--n];
                    int n5 = n2 - n4;
                    Cloneable cloneable = new LinkedHashMap(n5 < 2 ? 4 : (n5 < 4 ? 8 : (n5 < 12 ? 16 : (int)((float)n5 / 0.75f) + 1)));
                    for (n3 = n4; n3 < n2; n3 += 2) {
                        cloneable.put(objectArray[n3], objectArray[n3 + 1]);
                    }
                    n2 = n4;
                    objectArray = this.oexpand(objectArray, n2 + 1);
                    objectArray[n2++] = cloneable;
                }
            }
        } while ((!this.parser.isInterpretterMode() || n != 0) && (this.type = this.parser.next()) != null);
        return objectArray[0];
    }

    public int getDepth() {
        return this.parser.getDepth();
    }

    private int[] iexpand(int[] nArray, int n) {
        if (n > nArray.length) {
            int[] nArray2 = new int[nArray.length * 3 / 2 + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        return nArray;
    }

    private Object[] oexpand(Object[] objectArray, int n) {
        if (n > objectArray.length) {
            Object[] objectArray2 = new Object[objectArray.length * 3 / 2 + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray = objectArray2;
        }
        return objectArray;
    }
}

