/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

public abstract class NamingStyle {
    public static final NamingStyle LOWER_CASE = new NamingStyle("LOWER_CASE"){

        public String to(String string) {
            return NamingStyle.toSimpleCase(string, false);
        }
    };
    public static final NamingStyle LOWER_CAMEL = new NamingStyle("LOWER_CAMEL"){

        public String to(String string) {
            return NamingStyle.toCamelCase(string, false);
        }
    };
    public static final NamingStyle LOWER_SPACE = new NamingStyle("LOWER_SPACE"){

        public String to(String string) {
            return NamingStyle.toSeparatedCase(string, false, ' ');
        }
    };
    public static final NamingStyle LOWER_HYPHEN = new NamingStyle("LOWER_HYPHEN"){

        public String to(String string) {
            return NamingStyle.toSeparatedCase(string, false, '-');
        }
    };
    public static final NamingStyle LOWER_UNDERSCORE = new NamingStyle("LOWER_UNDERSCORE"){

        public String to(String string) {
            return NamingStyle.toSeparatedCase(string, false, '_');
        }
    };
    public static final NamingStyle UPPER_CASE = new NamingStyle("UPPER_CASE"){

        public String to(String string) {
            return NamingStyle.toSimpleCase(string, true);
        }
    };
    public static final NamingStyle UPPER_CAMEL = new NamingStyle("UPPER_CAMEL"){

        public String to(String string) {
            return NamingStyle.toCamelCase(string, true);
        }
    };
    public static final NamingStyle UPPER_SPACE = new NamingStyle("UPPER_SPACE"){

        public String to(String string) {
            return NamingStyle.toSeparatedCase(string, true, ' ');
        }
    };
    public static final NamingStyle UPPER_HYPHEN = new NamingStyle("UPPER_HYPHEN"){

        public String to(String string) {
            return NamingStyle.toSeparatedCase(string, true, '-');
        }
    };
    public static final NamingStyle UPPER_UNDERSCORE = new NamingStyle("UPPER_UNDERSCORE"){

        public String to(String string) {
            return NamingStyle.toSeparatedCase(string, true, '_');
        }
    };
    private String name;
    private static final int SEPARATOR = 1;
    private static final int LOWER = 2;
    private static final int UPPER = 3;
    private static final int NUMBER = 4;
    private static final int OTHER = 9;
    private static final int[] MAP = new int[128];

    public NamingStyle(String string) {
        this.name = string;
    }

    public abstract String to(String var1);

    public String toString() {
        return this.name;
    }

    private static String toSimpleCase(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            int n = NamingStyle.getType(cArray[i]);
            if (bl && n == 2) {
                cArray[i] = (char)(cArray[i] - 32);
                continue;
            }
            if (bl || n != 3) continue;
            cArray[i] = (char)(cArray[i] + 32);
        }
        return String.valueOf(cArray);
    }

    private static String toCamelCase(String string, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (string == null || string.isEmpty()) {
            return string;
        }
        for (n5 = 0; n5 < string.length() && ((n4 = NamingStyle.getType(string.charAt(n5))) == 1 || n4 == 9); ++n5) {
        }
        for (n3 = 0; n3 < string.length() - n5 && ((n4 = NamingStyle.getType(string.charAt(string.length() - n3 - 1))) == 1 || n4 == 9); ++n3) {
        }
        n4 = -1;
        for (n2 = n5; n2 < string.length() - n3; ++n2) {
            if (NamingStyle.getType(string.charAt(n2)) != 1) continue;
            n4 = n2;
            break;
        }
        if (n4 == -1) {
            n2 = NamingStyle.getType(string.charAt(n5));
            if (n2 == 3) {
                int n6;
                char[] cArray = string.toCharArray();
                if (!bl) {
                    cArray[n5] = (char)(cArray[n5] + 32);
                }
                for (int i = n5 + 1; i < cArray.length - n3 && NamingStyle.getType(cArray[i]) == 3 && (i + 1 >= cArray.length - n3 || (n6 = NamingStyle.getType(cArray[i + 1])) == 3 || n6 == 4); ++i) {
                    cArray[i] = (char)(cArray[i] + 32);
                }
                return String.valueOf(cArray);
            }
            if (bl && n2 == 2) {
                char[] cArray = string.toCharArray();
                cArray[n5] = (char)(cArray[n5] - 32);
                return String.valueOf(cArray);
            }
            return string;
        }
        char[] cArray = string.toCharArray();
        int n7 = n5;
        for (n = n5; n < cArray.length - n3; ++n) {
            if (NamingStyle.getType(cArray[n]) == 1) {
                bl = true;
                continue;
            }
            if (bl) {
                cArray[n7++] = NamingStyle.getType(cArray[n]) == 2 ? (char)(cArray[n] - 32) : cArray[n];
                bl = false;
                continue;
            }
            cArray[n7++] = NamingStyle.getType(cArray[n]) == 3 ? (char)(cArray[n] + 32) : cArray[n];
            bl = false;
        }
        for (n = 0; n < n3; ++n) {
            cArray[n7++] = cArray[cArray.length - n3];
        }
        return String.valueOf(cArray, 0, n7);
    }

    private static String toSeparatedCase(String string, boolean bl, char c) {
        int n;
        int n2;
        int n3;
        if (string == null || string.isEmpty()) {
            return string;
        }
        for (n3 = 0; n3 < string.length() && ((n2 = NamingStyle.getType(string.charAt(n3))) == 1 || n2 == 9); ++n3) {
        }
        for (n = 0; n < string.length() - n3 && ((n2 = NamingStyle.getType(string.charAt(string.length() - n - 1))) == 1 || n2 == 9); ++n) {
        }
        StringBuilder stringBuilder = new StringBuilder((int)((double)string.length() * 1.5));
        if (n3 > 0) {
            stringBuilder.append(string, 0, n3);
        }
        int n4 = -1;
        for (int i = n3; i < string.length() - n; ++i) {
            char c2 = string.charAt(i);
            int n5 = NamingStyle.getType(c2);
            if (n5 == 3 && n4 != -1) {
                int n6;
                if (n4 != 3 && n4 != 1) {
                    stringBuilder.append(c);
                } else if (i + 1 < string.length() - n && (n6 = NamingStyle.getType(string.charAt(i + 1))) != 3 && n6 != 4 && n6 != 1) {
                    stringBuilder.append(c);
                }
            }
            if (n5 == 1) {
                if (n4 != 1) {
                    stringBuilder.append(c);
                }
            } else if (bl && n5 == 2) {
                stringBuilder.append((char)(c2 - 32));
            } else if (!bl && n5 == 3) {
                stringBuilder.append((char)(c2 + 32));
            } else {
                stringBuilder.append(c2);
            }
            n4 = n5;
        }
        if (n > 0) {
            stringBuilder.append(string, string.length() - n, string.length());
        }
        return stringBuilder.toString();
    }

    private static int getType(char c) {
        return c < MAP.length ? MAP[c] : 0;
    }

    static {
        for (int i = 0; i < MAP.length; ++i) {
            NamingStyle.MAP[i] = i >= 65 && i <= 90 ? 3 : (i >= 97 && i <= 122 ? 2 : (i >= 48 && i <= 57 ? 4 : (i == 32 || i == 43 || i == 44 || i == 45 || i == 46 || i == 95 ? 1 : 9)));
        }
    }
}

