/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.time;

import java.time.DayOfWeek;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitDays;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Days
extends MockUnitBase
implements MockUnitDays {
    public static Days days() {
        return MockNeat.threadLocal().days();
    }

    protected Days() {
    }

    public Days(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<DayOfWeek> supplier() {
        return this.mockNeat.from(DayOfWeek.class)::val;
    }

    public MockUnitDays rangeClosed(DayOfWeek lower, DayOfWeek upper) {
        ValidationUtils.notNull(lower, "lower");
        ValidationUtils.notNull(upper, "upper");
        ValidationUtils.isTrue(lower.getValue() < upper.getValue(), "'lower' Month < 'upper' Month", new Object[0]);
        Supplier<DayOfWeek> supp = () -> {
            int idx = (Integer)this.mockNeat.ints().range(lower.getValue() - 1, upper.getValue()).val();
            return DayOfWeek.values()[idx];
        };
        return () -> supp;
    }

    public MockUnitDays range(DayOfWeek lower, DayOfWeek upper) {
        ValidationUtils.notNull(lower, "lower");
        ValidationUtils.notNull(upper, "upper");
        ValidationUtils.isTrue(lower.getValue() < upper.getValue(), "'lower' Month < 'upper' Month", new Object[0]);
        Supplier<DayOfWeek> supp = () -> {
            int idx = (Integer)this.mockNeat.ints().range(lower.getValue() - 1, upper.getValue() - 1).val();
            return DayOfWeek.values()[idx];
        };
        return () -> supp;
    }

    public MockUnitDays before(DayOfWeek before) {
        ValidationUtils.notNull(before, "before");
        ValidationUtils.isTrue(before.getValue() - 1 > 0, "Cannot use 'Monday' as 'before'. 'Monday' is considered to be the first day of the week.", new Object[0]);
        return this.range(DayOfWeek.values()[0], before);
    }

    public MockUnitDays after(DayOfWeek after) {
        ValidationUtils.notNull(after, "after");
        ValidationUtils.isTrue(after.getValue() - 1 < DayOfWeek.values().length - 1, "Cannot use 'Sunday' as 'after'. 'Sunday' is considered to be the last day of the week.", new Object[0]);
        Supplier<DayOfWeek> supp = () -> {
            int idx = (Integer)this.mockNeat.ints().range(after.getValue(), DayOfWeek.values().length).val();
            return DayOfWeek.values()[idx];
        };
        return () -> supp;
    }
}

