/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockConstValue;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.abstraction.MockUnitValue;
import net.andreinc.mockneat.abstraction.MockValue;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.StringUtils;

public final class Formatter
implements MockUnitString {
    private final Map<String, MockValue<?>> fields = new HashMap();
    private final String fmt;

    public static Formatter fmt(String fmt) {
        return MockNeat.threadLocal().fmt(fmt);
    }

    public static Formatter formatter(String fmt) {
        return new Formatter(fmt);
    }

    public Formatter(String fmt) {
        ValidationUtils.notEmpty(fmt, "fmt");
        this.fmt = fmt;
    }

    public <T> Formatter param(String param, MockUnit<T> mock) {
        ValidationUtils.notEmpty(param, "param");
        ValidationUtils.notNull(mock, "mock");
        ValidationUtils.isTrue(StringUtils.isAlphanumeric((CharSequence)param), "Input param '#{input}' should be alpha-numeric.", "input", param);
        this.fields.put(param, MockUnitValue.unit(mock));
        return this;
    }

    public Formatter param(String param, String constValue) {
        ValidationUtils.notEmpty(param, "param");
        ValidationUtils.notNull(constValue, "constValue");
        ValidationUtils.isTrue(StringUtils.isAlphanumeric((CharSequence)param), "Input param '#{input}' should be alpha-numeric.", "input", param);
        this.fields.put(param, MockConstValue.constant(param));
        return this;
    }

    @Override
    public Supplier<String> supplier() {
        return () -> {
            Map<String, Object> args = this.fields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MockValue)e.getValue()).getStr()));
            return AlephFormatter.str((String)this.fmt).args(args).fmt();
        };
    }
}

