/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.networking;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.enums.DomainSuffixType;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Domains
extends MockUnitBase
implements MockUnitString {
    public static Domains domains() {
        return MockNeat.threadLocal().domains();
    }

    protected Domains() {
    }

    public Domains(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<String> supplier() {
        return this.type(DomainSuffixType.POPULAR)::val;
    }

    public MockUnitString popular() {
        return this.type(DomainSuffixType.POPULAR);
    }

    public MockUnitString all() {
        return this.type(DomainSuffixType.ALL);
    }

    public MockUnitString type(DomainSuffixType type) {
        ValidationUtils.notNull(type, "type");
        return () -> this.mockNeat.dicts().type(type.getDictType())::val;
    }

    public MockUnitString types(DomainSuffixType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        return () -> {
            DomainSuffixType type = this.mockNeat.from(types).val();
            return this.type(type).supplier();
        };
    }
}

