/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.celebrities;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.enums.CelebrityType;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.unit.celebrities.Actors;
import net.andreinc.mockneat.unit.celebrities.Actresses;
import net.andreinc.mockneat.unit.celebrities.JazzArtists;
import net.andreinc.mockneat.unit.celebrities.RockStars;
import net.andreinc.mockneat.unit.celebrities.UKPrimeMinisters;
import net.andreinc.mockneat.unit.celebrities.USPresidents;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Celebrities
extends MockUnitBase
implements MockUnitString {
    private final JazzArtists jazzArtists;
    private final RockStars rockStars;
    private final USPresidents usPresidents;
    private final UKPrimeMinisters ukPrimeMinisters;
    private final Actors actors;
    private final Actresses actresses;

    public static Celebrities celebrities() {
        return MockNeat.threadLocal().celebrities();
    }

    public Celebrities(MockNeat mockNeat) {
        super(mockNeat);
        this.rockStars = new RockStars(mockNeat);
        this.usPresidents = new USPresidents(mockNeat);
        this.ukPrimeMinisters = new UKPrimeMinisters(mockNeat);
        this.jazzArtists = new JazzArtists(mockNeat);
        this.actors = new Actors(mockNeat);
        this.actresses = new Actresses(mockNeat);
    }

    public JazzArtists jazzArtists() {
        return this.jazzArtists;
    }

    public RockStars rockStars() {
        return this.rockStars;
    }

    public UKPrimeMinisters ukPrimeMinisters() {
        return this.ukPrimeMinisters;
    }

    public USPresidents usPresidents() {
        return this.usPresidents;
    }

    public Actors actors() {
        return this.actors;
    }

    public Actresses actresses() {
        return this.actresses;
    }

    public MockUnitString type(CelebrityType celebrityType) {
        Validate.notNull((Object)((Object)celebrityType), (String)"celebrityType", (Object[])new Object[0]);
        DictType dictType = this.mockNeat.from(celebrityType.getDictionaries()).val();
        return () -> this.mockNeat.dicts().type(dictType)::get;
    }

    public MockUnitString types(CelebrityType ... celebrityTypes) {
        ValidationUtils.notEmptyOrNullValues(celebrityTypes, "celebrityTypes");
        return () -> {
            CelebrityType type = this.mockNeat.from(celebrityTypes).get();
            return this.type(type).supplier();
        };
    }

    @Override
    public Supplier<String> supplier() {
        return () -> {
            CelebrityType celebrityType = this.mockNeat.from(CelebrityType.class).get();
            return (String)this.type(celebrityType).get();
        };
    }
}

