/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.abstraction;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.types.enums.StringFormatType;
import net.andreinc.mockneat.utils.MockUnitUtils;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.text.StringEscapeUtils;

@FunctionalInterface
public interface MockUnitString
extends MockUnit<String> {
    default public MockUnitString accumulate(int times, String separator) {
        ValidationUtils.notNull(separator, "separator");
        ValidationUtils.isTrue(times > 0, "The number of times should be a positive number.", new Object[0]);
        Supplier<String> supplier = () -> {
            StringBuilder buff = new StringBuilder();
            int counter = times;
            while (counter-- > 0) {
                buff.append((String)this.val()).append(separator);
            }
            if (!separator.isEmpty()) {
                int length = separator.length();
                buff.delete(buff.length() - length, buff.length());
            }
            return buff.toString();
        };
        return () -> supplier;
    }

    default public MockUnitString format(StringFormatType formatType) {
        ValidationUtils.notNull(formatType, "formatType");
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), formatType.getFormatter());
    }

    default public MockUnitString sub(int endIndex) {
        return this.sub(0, endIndex);
    }

    default public MockUnitString sub(int beginIndex, int endIndex) {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), s -> s.substring(beginIndex, endIndex));
    }

    default public MockUnitString append(String str) {
        ValidationUtils.notNull(str, "str");
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), s -> s.concat(str));
    }

    default public MockUnitString prepend(String str) {
        ValidationUtils.notNull(str, "str");
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), str::concat);
    }

    default public MockUnitString replace(char oldCHar, char newChar) {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), s -> s.replace(oldCHar, newChar));
    }

    default public MockUnitString replace(CharSequence target, CharSequence replacement) {
        ValidationUtils.notNull(target, "target");
        ValidationUtils.notNull(replacement, "replacement");
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), s -> s.replace(target, replacement));
    }

    default public MockUnitString replaceAll(String regex, String replacement) {
        ValidationUtils.notNull(regex, "regex");
        ValidationUtils.notNull(replacement, "replacement");
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), s -> s.replaceAll(regex, replacement));
    }

    default public MockUnitString replaceFirst(String regex, String replacement) {
        ValidationUtils.notNull(regex, "regex");
        ValidationUtils.notNull(replacement, "replacement");
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), s -> s.replaceFirst(regex, replacement));
    }

    default public MockUnit<String[]> split(String regex, int limit) {
        ValidationUtils.notNull(regex, "regex");
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), s -> s.split(regex, limit));
    }

    default public MockUnit<String[]> split(String regex) {
        return this.split(regex, 0);
    }

    default public MockUnitString urlEncode(String encoding) {
        ValidationUtils.notNull(encoding, "encoding");
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), s -> {
            try {
                return URLEncoder.encode(s, encoding);
            }
            catch (UnsupportedEncodingException e) {
                String msg = AlephFormatter.str((String)"Cannot URL encode the following string: '#{val}'. Encoding: '#{encoding}' looks invalid.").args(new Object[]{"val", s, "encoding", encoding}).fmt();
                throw new IllegalArgumentException(msg, e);
            }
        });
    }

    default public MockUnitString urlEncode() {
        return this.urlEncode("UTF-8");
    }

    default public MockUnitString noSpecialChars() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), s -> s.replaceAll("[^\\dA-Za-z ]", ""));
    }

    default public MockUnitString escapeCsv() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), StringEscapeUtils::escapeCsv);
    }

    default public MockUnitString escapeEcmaScript() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), StringEscapeUtils::escapeEcmaScript);
    }

    default public MockUnitString escapeHtml() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), StringEscapeUtils::escapeHtml4);
    }

    default public MockUnitString escapeXml() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), StringEscapeUtils::escapeXml11);
    }

    default public MockUnitString md2() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), DigestUtils::md2Hex);
    }

    default public MockUnitString md5() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), DigestUtils::md5Hex);
    }

    default public MockUnitString sha1() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), DigestUtils::sha1Hex);
    }

    default public MockUnitString sha256() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), DigestUtils::sha256Hex);
    }

    default public MockUnitString sha384() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), DigestUtils::sha384Hex);
    }

    default public MockUnitString sha512() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), DigestUtils::sha512Hex);
    }

    default public MockUnitString base64() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), str -> new Base64().encodeAsString(str.getBytes(Charset.defaultCharset())));
    }

    default public MockUnit<String[]> array(int size) {
        return this.array(String.class, size);
    }
}

