/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.time;

import java.time.LocalDate;
import java.time.Month;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitLocalDate;
import net.andreinc.mockneat.utils.ValidationUtils;

public class LocalDates
extends MockUnitBase
implements MockUnitLocalDate {
    public static final LocalDate EPOCH_START = LocalDate.ofEpochDay(0L);

    public static LocalDates localDates() {
        return MockNeat.threadLocal().localDates();
    }

    protected LocalDates() {
    }

    public LocalDates(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<LocalDate> supplier() {
        return this.between(EPOCH_START, LocalDate.now())::val;
    }

    public MockUnitLocalDate thisYear() {
        Supplier<LocalDate> supp = () -> {
            int year = LocalDate.now().getYear();
            int maxDays = LocalDate.now().lengthOfYear() + 1;
            int randDay = (Integer)this.mockNeat.ints().range(1, maxDays).val();
            return LocalDate.ofYearDay(year, randDay);
        };
        return () -> supp;
    }

    public MockUnitLocalDate thisMonth() {
        Supplier<LocalDate> supp = () -> {
            int year = LocalDate.now().getYear();
            Month month = LocalDate.now().getMonth();
            int lM = LocalDate.now().lengthOfMonth() + 1;
            int randDay = (Integer)this.mockNeat.ints().range(1, lM).val();
            return LocalDate.of(year, month, randDay);
        };
        return () -> supp;
    }

    public MockUnitLocalDate between(LocalDate lowerDate, LocalDate upperDate) {
        ValidationUtils.notNull(lowerDate, "lowerDate");
        ValidationUtils.notNull(upperDate, "upperDate");
        ValidationUtils.isTrue(lowerDate.compareTo(upperDate) < 0, "lowerDate '#{lower}' should be < than upperDate '#{upper}'.", "lower", lowerDate, "upper", upperDate);
        Supplier<LocalDate> supp = () -> {
            long lowerEpoch = lowerDate.toEpochDay();
            long upperEpoch = upperDate.toEpochDay();
            long diff = upperEpoch - lowerEpoch;
            long randEpoch = (Long)this.mockNeat.longs().range(0L, diff).val();
            return LocalDate.ofEpochDay(lowerEpoch + randEpoch);
        };
        return () -> supp;
    }

    public MockUnitLocalDate future(LocalDate maxDate) {
        ValidationUtils.notNull(maxDate, "maxDate");
        ValidationUtils.isTrue(maxDate.compareTo(LocalDate.MAX.minusDays(1L)) <= 0, "maxDate '#{max}'  should be < than '#{date}' (LocalDates.MAX)", "max", maxDate, "date", LocalDate.MAX.minusDays(1L));
        ValidationUtils.isTrue(maxDate.plusDays(1L).compareTo(LocalDate.now()) > 0, "maxDate '#{max}' should be > than now() (#{now}).", "max", maxDate, "now", LocalDate.now());
        return this.between(LocalDate.now().plusDays(1L), maxDate.plusDays(1L));
    }

    public MockUnitLocalDate past(LocalDate minDate) {
        ValidationUtils.notNull(minDate, "minDate");
        ValidationUtils.isTrue(minDate.compareTo(LocalDate.MIN) > 0, "minDate '#{min}' should be > than '#{date}' (LocalDate.MIN)", "min", minDate, "date", LocalDate.MIN);
        ValidationUtils.isTrue(minDate.minusDays(1L).compareTo(LocalDate.now()) < 0, "minDate '#{min}' should be < than now() (#{now}).", "min", minDate, "now", LocalDate.now());
        return this.between(minDate, LocalDate.now());
    }
}

