/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text.sql;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.unit.text.sql.SQLInsert;
import net.andreinc.mockneat.utils.ValidationUtils;

public class SQLTable {
    private final List<SQLInsert> inserts;
    private final MockNeat mockNeat;

    public SQLTable(MockNeat mockNeat, List<SQLInsert> inserts) {
        ValidationUtils.notNull(mockNeat, "mockNeat");
        ValidationUtils.notNull(inserts, "inserts");
        this.inserts = inserts;
        this.mockNeat = mockNeat;
    }

    public MockUnitString fromColumn(String columnName) {
        ValidationUtils.notEmpty(columnName, "columnName");
        return this.mockNeat.from(this.inserts).mapToString(insert -> insert.getValue(columnName));
    }

    public Optional<SQLInsert> selectFirstWhere(Predicate<SQLInsert> condition) {
        ValidationUtils.notNull(condition, "condition");
        return this.inserts.stream().filter(condition).findFirst();
    }

    public List<SQLInsert> selectWhere(Predicate<SQLInsert> condition) {
        ValidationUtils.notNull(condition, "condition");
        return this.inserts.stream().filter(condition).collect(Collectors.toList());
    }

    public SQLInsert selectRow(int row) {
        ValidationUtils.isTrue(row >= 0, "The row should be a positive value. (>=0)", new Object[0]);
        return this.inserts.get(row);
    }

    public SQLTable update(int row, String column, String newValue) {
        ValidationUtils.isTrue(row >= 0, "The row should be a positive value. (>=0)", new Object[0]);
        ValidationUtils.notEmpty(column, "column");
        ValidationUtils.notEmpty(newValue, "newValue");
        this.inserts.get(row).setValue(column, newValue);
        return this;
    }

    public SQLTable update(int row, Consumer<SQLInsert> updater) {
        ValidationUtils.isTrue(row >= 0, "The row should be a positive value. (>=0)", new Object[0]);
        ValidationUtils.notNull(updater, "updater");
        updater.accept(this.inserts.get(row));
        return this;
    }

    public SQLTable updateAll(BiConsumer<Integer, SQLInsert> updater) {
        ValidationUtils.notNull(updater, "updater");
        IntStream.range(0, this.inserts.size()).forEach(i -> updater.accept(i, this.inserts.get(i)));
        return this;
    }

    public int size() {
        return this.inserts.size();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        this.inserts.stream().map(SQLInsert::toString).forEach(sql -> buff.append((String)sql).append("\n"));
        return buff.toString();
    }
}

