/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Shufflers
extends MockUnitBase {
    public static Shufflers shufflers() {
        return MockNeat.threadLocal().shufflers();
    }

    protected Shufflers() {
    }

    public Shufflers(MockNeat mockNeat) {
        super(mockNeat);
    }

    public <T> MockUnit<T[]> array(T[] source) {
        ValidationUtils.notNull(source, "source");
        Supplier<Object[]> supplier = () -> {
            Object[] result = (Object[])source.clone();
            for (int i = 0; i < result.length - 2; ++i) {
                int j = (Integer)this.mockNeat.ints().range(i, result.length).val();
                Object tmp = result[i];
                result[i] = result[j];
                result[j] = tmp;
            }
            return result;
        };
        return () -> supplier;
    }

    public MockUnit<int[]> arrayInt(int[] source) {
        ValidationUtils.notNull(source, "source");
        Supplier<int[]> supplier = () -> {
            int[] result = (int[])source.clone();
            for (int i = 0; i < result.length; ++i) {
                int j = (Integer)this.mockNeat.ints().range(i, result.length).val();
                int tmp = result[i];
                result[i] = result[j];
                result[j] = tmp;
            }
            return result;
        };
        return () -> supplier;
    }

    public MockUnit<long[]> arrayLong(long[] source) {
        ValidationUtils.notNull(source, "source");
        Supplier<long[]> supplier = () -> {
            long[] result = (long[])source.clone();
            for (int i = 0; i < result.length; ++i) {
                int j = (Integer)this.mockNeat.ints().range(i, result.length).val();
                long tmp = result[i];
                result[i] = result[j];
                result[j] = tmp;
            }
            return result;
        };
        return () -> supplier;
    }

    public MockUnit<double[]> arrayDouble(double[] source) {
        ValidationUtils.notNull(source, "source");
        Supplier<double[]> supplier = () -> {
            double[] result = (double[])source.clone();
            for (int i = 0; i < result.length; ++i) {
                int j = (Integer)this.mockNeat.ints().range(i, result.length).val();
                double tmp = result[i];
                result[i] = result[j];
                result[j] = tmp;
            }
            return result;
        };
        return () -> supplier;
    }

    public MockUnit<float[]> arrayFloat(float[] source) {
        ValidationUtils.notNull(source, "source");
        Supplier<float[]> supplier = () -> {
            float[] result = (float[])source.clone();
            for (int i = 0; i < result.length; ++i) {
                int j = (Integer)this.mockNeat.ints().range(i, result.length).val();
                float tmp = result[i];
                result[i] = result[j];
                result[j] = tmp;
            }
            return result;
        };
        return () -> supplier;
    }

    public <T> MockUnit<ArrayList<T>> arrayList(ArrayList<T> source) {
        ValidationUtils.notNull(source, "source");
        Supplier<ArrayList> supplier = () -> {
            ArrayList result = (ArrayList)source.clone();
            for (int i = 0; i < result.size() - 2; ++i) {
                int j = (Integer)this.mockNeat.ints().range(i, result.size()).val();
                Object tmp = result.get(i);
                result.set(i, result.get(j));
                result.set(j, tmp);
            }
            return result;
        };
        return () -> supplier;
    }

    public MockUnitString string(String source) {
        ValidationUtils.notNull(source, "source");
        Supplier<String> supplier = () -> {
            char[] chars = source.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                int j = (Integer)this.mockNeat.ints().range(i, chars.length).val();
                char c = chars[i];
                chars[i] = chars[j];
                chars[j] = c;
            }
            return new String(chars);
        };
        return () -> supplier;
    }
}

