/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.utils.MockUnitUtils;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class Factory<T, R>
implements MockUnit<T> {
    private static final Pattern JAVA_FIELD_REGEX = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
    private final Class<T> targetClass;
    private final Class<R> factoryClass;
    private String method;
    private Object[] params = new Object[0];

    public static <T, FT> Factory<T, FT> factory(Class<T> targetClass, Class<FT> factoryClass) {
        return MockNeat.threadLocal().factory(targetClass, factoryClass);
    }

    public Factory(Class<T> targetClass, Class<R> factoryClass) {
        this.targetClass = targetClass;
        this.factoryClass = factoryClass;
    }

    public Factory<T, R> method(String methodName) {
        this.method = methodName;
        return this;
    }

    public Factory<T, R> params(Object ... params) {
        this.params = params;
        return this;
    }

    @Override
    public Supplier<T> supplier() {
        ValidationUtils.notNull(this.targetClass, "targetClass");
        ValidationUtils.notNull(this.factoryClass, "factoryClass");
        ValidationUtils.notNull(this.params, "params");
        ValidationUtils.notEmpty(this.method, "method");
        ValidationUtils.isTrue(JAVA_FIELD_REGEX.matcher(this.method).matches(), AlephFormatter.str((String)"Method '#{method}' doesn't match the Java Naming Conventions for methods.").args(new Object[]{"method", this.method}).fmt(), new Object[0]);
        Object[] args = new Object[this.params.length];
        return () -> {
            Object result;
            try {
                IntStream.range(0, this.params.length).forEach(i -> {
                    args[i] = MockUnitUtils.mockOrObject(this.params[i]);
                });
                result = MethodUtils.invokeExactStaticMethod(this.factoryClass, (String)this.method, (Object[])args);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String fmt = AlephFormatter.str((String)"Cannot invoke '#{cls.class.name}.#{method}()' with params: '#{types}'.").arg("cls", this.targetClass).arg("method", (Object)this.method).arg("types", (Object)MockUnitUtils.listTypes(args)).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
            return result;
        };
    }
}

