/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.types.enums;

import java.util.Arrays;
import java.util.List;
import net.andreinc.mockneat.types.Pair;
import net.andreinc.mockneat.types.enums.CharsType;

public enum IBANType {
    ALBANIA(8, "AL", Pair.of(8, CharsType.DIGITS), Pair.of(16, CharsType.ALPHA_NUMERIC)),
    ANDORRA(24, "AD", Pair.of(8, CharsType.DIGITS), Pair.of(12, CharsType.ALPHA_NUMERIC)),
    AUSTRIA(20, "AT", Pair.of(16, CharsType.DIGITS)),
    AZERBAIJAN(28, "AZ", Pair.of(4, CharsType.ALPHA_NUMERIC), Pair.of(20, CharsType.DIGITS)),
    BAHRAIN(22, "BH", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(14, CharsType.ALPHA_NUMERIC)),
    BELARUS(28, "BY", Pair.of(4, CharsType.ALPHA_NUMERIC), Pair.of(20, CharsType.DIGITS)),
    BELGIUM(16, "BE", Pair.of(12, CharsType.DIGITS)),
    BOSNIA_AND_HERZEGOVINA(20, "BA", Pair.of(16, CharsType.DIGITS)),
    BRAZIL(29, "BR", Pair.of(23, CharsType.DIGITS), Pair.of(1, CharsType.UPPER_LETTERS), Pair.of(1, CharsType.ALPHA_NUMERIC)),
    BULGARIA(22, "BG", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(6, CharsType.DIGITS), Pair.of(8, CharsType.ALPHA_NUMERIC)),
    COSTA_RICA(22, "CR", Pair.of(17, CharsType.DIGITS)),
    CYPRUS(28, "CY", Pair.of(8, CharsType.DIGITS), Pair.of(16, CharsType.ALPHA_NUMERIC)),
    CZECH_REPUBLIC(24, "CZ", Pair.of(20, CharsType.DIGITS)),
    DENMARK(18, "DK", Pair.of(14, CharsType.DIGITS)),
    DOMINICAN_REPUBLIC(28, "DO", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(20, CharsType.DIGITS)),
    EAST_TIMOR(23, "TL", Pair.of(19, CharsType.DIGITS)),
    ESTONIA(20, "EE", Pair.of(16, CharsType.DIGITS)),
    FAROE_ISLANDS(18, "FO", Pair.of(14, CharsType.DIGITS)),
    FINLAND(18, "FI", Pair.of(14, CharsType.DIGITS)),
    FRANCE(27, "FR", Pair.of(10, CharsType.DIGITS), Pair.of(11, CharsType.ALPHA_NUMERIC), Pair.of(2, CharsType.DIGITS)),
    GEORGIA(22, "GE", Pair.of(2, CharsType.ALPHA_NUMERIC), Pair.of(16, CharsType.DIGITS)),
    GERMANY(22, "DE", Pair.of(18, CharsType.DIGITS)),
    GIBRALTAR(23, "GI", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(15, CharsType.ALPHA_NUMERIC)),
    GREECE(27, "GR", Pair.of(7, CharsType.DIGITS), Pair.of(16, CharsType.ALPHA_NUMERIC)),
    GREENLAND(18, "GL", Pair.of(14, CharsType.DIGITS)),
    GUATEMALA(28, "GT", Pair.of(4, CharsType.ALPHA_NUMERIC), Pair.of(20, CharsType.ALPHA_NUMERIC)),
    HUNGARY(28, "HU", Pair.of(24, CharsType.DIGITS)),
    ICELAND(26, "IS", Pair.of(22, CharsType.DIGITS)),
    IRELAND(22, "IE", Pair.of(4, CharsType.ALPHA_NUMERIC), Pair.of(14, CharsType.DIGITS)),
    ISRAEL(23, "IL", Pair.of(19, CharsType.DIGITS)),
    ITALY(27, "IT", Pair.of(1, CharsType.UPPER_LETTERS), Pair.of(10, CharsType.DIGITS), Pair.of(12, CharsType.ALPHA_NUMERIC)),
    JORDAN(30, "JO", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(22, CharsType.DIGITS)),
    KAZAKHSTAN(20, "KZ", Pair.of(3, CharsType.DIGITS), Pair.of(13, CharsType.ALPHA_NUMERIC)),
    KOSOVO(20, "XK", Pair.of(4, CharsType.DIGITS), Pair.of(10, CharsType.DIGITS), Pair.of(2, CharsType.DIGITS)),
    KUWAIT(30, "KW", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(22, CharsType.ALPHA_NUMERIC)),
    LATVIA(21, "LV", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(13, CharsType.ALPHA_NUMERIC)),
    LEBANON(28, "LB", Pair.of(4, CharsType.DIGITS), Pair.of(20, CharsType.ALPHA_NUMERIC)),
    LIECHTENSTEIN(21, "LI", Pair.of(5, CharsType.DIGITS), Pair.of(12, CharsType.ALPHA_NUMERIC)),
    LITHUANIA(20, "LT", Pair.of(16, CharsType.DIGITS)),
    LUXEMBOURG(20, "LU", Pair.of(3, CharsType.DIGITS), Pair.of(13, CharsType.ALPHA_NUMERIC)),
    MACEDONIA(19, "MK", Pair.of(3, CharsType.DIGITS), Pair.of(10, CharsType.ALPHA_NUMERIC), Pair.of(2, CharsType.DIGITS)),
    MALTA(31, "MT", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(5, CharsType.DIGITS), Pair.of(18, CharsType.ALPHA_NUMERIC)),
    MAURITANIA(27, "MR", Pair.of(23, CharsType.DIGITS)),
    MAURITIUS(30, "MU", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(19, CharsType.DIGITS), Pair.of(3, CharsType.UPPER_LETTERS)),
    MONACO(27, "MC", Pair.of(10, CharsType.DIGITS), Pair.of(11, CharsType.ALPHA_NUMERIC), Pair.of(2, CharsType.DIGITS)),
    MOLDOVA(24, "MD", Pair.of(2, CharsType.ALPHA_NUMERIC), Pair.of(18, CharsType.ALPHA_NUMERIC)),
    MONTENEGRO(22, "ME", Pair.of(18, CharsType.DIGITS)),
    NETHERLANDS(18, "NL", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(10, CharsType.DIGITS)),
    NORWAY(15, "NO", Pair.of(11, CharsType.DIGITS)),
    PAKISTAN(24, "PK", Pair.of(4, CharsType.ALPHA_NUMERIC), Pair.of(16, CharsType.DIGITS)),
    PALESTINIAN_TERRITORIES(29, "PS", Pair.of(4, CharsType.ALPHA_NUMERIC), Pair.of(21, CharsType.DIGITS)),
    POLAND(28, "PL", Pair.of(24, CharsType.DIGITS)),
    PORTUGAL(25, "PT", Pair.of(21, CharsType.DIGITS)),
    QATAR(29, "QA", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(21, CharsType.ALPHA_NUMERIC)),
    ROMANIA(24, "RO", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(16, CharsType.ALPHA_NUMERIC)),
    SAN_MARINO(27, "SM", Pair.of(1, CharsType.UPPER_LETTERS), Pair.of(10, CharsType.DIGITS), Pair.of(12, CharsType.ALPHA_NUMERIC)),
    SAUDI_ARABIA(24, "SA", Pair.of(2, CharsType.DIGITS), Pair.of(18, CharsType.ALPHA_NUMERIC)),
    SERBIA(22, "RS", Pair.of(18, CharsType.DIGITS)),
    SLOVAKIA(24, "SK", Pair.of(20, CharsType.DIGITS)),
    SLOVENIA(19, "SI", Pair.of(15, CharsType.DIGITS)),
    SPAIN(24, "ES", Pair.of(20, CharsType.DIGITS)),
    SWEDEN(24, "SE", Pair.of(24, CharsType.DIGITS)),
    SWITZERLAND(21, "CH", Pair.of(5, CharsType.DIGITS), Pair.of(12, CharsType.ALPHA_NUMERIC)),
    TUNISIA(24, "TN", Pair.of(20, CharsType.DIGITS)),
    TURKEY(26, "TR", Pair.of(5, CharsType.DIGITS), Pair.of(17, CharsType.ALPHA_NUMERIC)),
    UAE(23, "AE", Pair.of(3, CharsType.DIGITS), Pair.of(16, CharsType.ALPHA_NUMERIC)),
    UK(22, "GB", Pair.of(4, CharsType.UPPER_LETTERS), Pair.of(14, CharsType.DIGITS));

    private final int length;
    private final String prefix;
    private final List<Pair<Integer, CharsType>> bban;

    @SafeVarargs
    private IBANType(int length, String prefix, Pair<Integer, CharsType> ... charsGroup) {
        this.length = length;
        this.prefix = prefix;
        this.bban = Arrays.asList(charsGroup);
    }

    public int getLength() {
        return this.length;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<Pair<Integer, CharsType>> getBban() {
        return this.bban;
    }
}

