/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.user;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.NameType;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Names
implements MockUnitString {
    private final MockNeat mock;

    public Names(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<String> supplier() {
        return this.full().supplier();
    }

    public MockUnitString first() {
        return this.type(NameType.FIRST_NAME);
    }

    public MockUnitString last() {
        return this.type(NameType.LAST_NAME);
    }

    public MockUnitString full() {
        Supplier<String> supp = () -> (String)this.first().val() + " " + (String)this.last().val();
        return () -> supp;
    }

    public MockUnitString full(double middleInitialProbability) {
        Validate.inclusiveBetween((double)0.0, (double)100.0, (double)middleInitialProbability);
        Supplier<String> supp = () -> {
            boolean middleName = this.mock.bools().probability(middleInitialProbability).val();
            String initial = middleName ? " " + this.mock.chars().upperLetters().val() + "." : "";
            return (String)this.first().val() + initial + " " + (String)this.last().val();
        };
        return () -> supp;
    }

    public MockUnitString types(NameType ... types) {
        ValidationUtils.notEmptyTypes(types);
        NameType nameType = this.mock.from(types).val();
        return this.type(nameType);
    }

    public MockUnitString type(NameType type) {
        Validate.notNull((Object)((Object)type), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"type"});
        DictType dictType = this.mock.from(type.getDictionaries()).val();
        return () -> this.mock.dicts().type(dictType)::val;
    }
}

