/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text.markov;

import java.util.Arrays;
import java.util.List;

public class WordState {
    private final String[] state;

    private WordState(String ... strings) {
        this.state = strings;
    }

    public static WordState fromWords(List<String> words, int stateSize, int fromIdx) {
        String[] result = new String[stateSize];
        for (int i = 0; i < stateSize; ++i) {
            result[i] = words.get(i + fromIdx);
        }
        return new WordState(result);
    }

    public WordState nextState(String word) {
        String[] newState = new String[this.state.length];
        System.arraycopy(this.state, 1, newState, 0, this.state.length - 1);
        newState[this.state.length - 1] = word;
        return new WordState(newState);
    }

    public String[] getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordState wordState = (WordState)o;
        return Arrays.equals(this.state, wordState.state);
    }

    public int hashCode() {
        return Arrays.hashCode(this.state);
    }
}

