/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text.markov;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.types.enums.MarkovChainType;
import net.andreinc.mockneat.unit.text.markov.WordState;
import net.andreinc.mockneat.unit.text.markov.WordStatistic;
import net.andreinc.mockneat.utils.file.FileManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkovUnit {
    private static final FileManager fm = FileManager.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(MarkovUnit.class);
    private final String path;
    private final Map<WordState, WordStatistic> chain;
    private final MockUnit<WordState> randState;
    private Integer stateSize = 2;
    private MockNeat mock = MockNeat.threadLocal();

    private MarkovUnit(MockNeat mock, List<String> lines, String path, Integer stateSize) {
        this.path = path;
        this.stateSize = stateSize;
        this.chain = this.getChain(this.getRawChain(this.getWords(lines)));
        this.mock = mock;
        this.randState = this.mock.fromKeys(this.chain);
    }

    public static MarkovUnit internal(MockNeat mock, MarkovChainType chainType, int stateSize) throws IOException {
        return new MarkovUnit(mock, fm.read(chainType), chainType.getFile(), stateSize);
    }

    public static MarkovUnit external(MockNeat mock, String path, int stateSize) throws IOException {
        return new MarkovUnit(mock, fm.read(path), path, stateSize);
    }

    private List<String> getWords(List<String> lines) {
        logger.info("Obtaining the list of words from: '{}'.", (Object)this.path);
        ArrayList<String> words = new ArrayList<String>();
        lines.forEach(line -> {
            line = line.replaceAll("\"", " ");
            Arrays.stream(line.split(" ")).forEach(word -> {
                String trimmed = StringUtils.lowerCase((String)word.trim());
                if (!"".equals(word)) {
                    words.add(trimmed);
                }
            });
        });
        logger.info("{} words detected in '{}'.", (Object)words.size(), (Object)this.path);
        return words;
    }

    private Map<WordState, Map<String, Integer>> getRawChain(List<String> words) {
        logger.info("Building WordState(s) from the words found in '{}'.", (Object)this.path);
        HashMap<WordState, Map<String, Integer>> result = new HashMap<WordState, Map<String, Integer>>();
        int stop = words.size() - this.stateSize;
        for (int i = 0; i < stop; ++i) {
            Integer currentCount;
            String nextWord = words.get(i + this.stateSize);
            WordState currentState = WordState.fromWords(words, this.stateSize, i);
            HashMap<String, Integer> currentRawValue = (HashMap<String, Integer>)result.get(currentState);
            if (null == currentRawValue) {
                currentRawValue = new HashMap<String, Integer>();
                result.put(currentState, currentRawValue);
            }
            if (null == (currentCount = (Integer)currentRawValue.get(nextWord))) {
                currentCount = 0;
            }
            currentCount = currentCount + 1;
            currentRawValue.put(nextWord, currentCount);
        }
        logger.info("{} WordState(s) detected in '{}'.", (Object)result.keySet().size(), (Object)this.path);
        return result;
    }

    private Map<WordState, WordStatistic> getChain(Map<WordState, Map<String, Integer>> rawChain) {
        return rawChain.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new WordStatistic((Map)e.getValue())));
    }

    public String generateText(Integer maxLength) {
        StringBuilder buff = new StringBuilder();
        WordState state = this.randState.val();
        String prev = ".";
        while (buff.length() < maxLength) {
            WordStatistic statistic = this.chain.get(state);
            while (null == statistic) {
                statistic = this.chain.get(this.randState.val());
            }
            String next = statistic.nextWord();
            state = state.nextState(next);
            if (prev.endsWith(".")) {
                next = WordUtils.capitalize((String)next);
            }
            prev = next;
            buff.append(next).append(" ");
        }
        return buff.subSequence(0, maxLength).toString();
    }
}

