/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.alphabets.Alphabets;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.types.enums.StringType;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.Validate;

public class Strings
implements MockUnitString {
    private final MockNeat mock;
    private final Random random;
    private int size = 64;

    public Strings(MockNeat mock) {
        this.mock = mock;
        this.random = mock.getRandom();
    }

    public Strings size(int size) {
        Validate.isTrue((size > 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>).", (Object[])new Object[0]);
        this.size = size;
        return this;
    }

    public MockUnitString type(StringType type) {
        Validate.notNull((Object)((Object)type), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"type"});
        switch (type) {
            case HEX: {
                return this::hex;
            }
            case NUMBERS: {
                return this::numbers;
            }
            case LETTERS: {
                return this::letters;
            }
            case ALPHA_NUMERIC: {
                return this::alphaNumeric;
            }
            case SPECIAL_CHARACTERS: {
                return this::specialChars;
            }
        }
        throw new IllegalArgumentException("Invalid StringType");
    }

    public MockUnitString types(StringType ... types) {
        Validate.notEmpty((Object[])types, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"types"});
        StringType type = this.mock.from(types).val();
        return this.type(type);
    }

    private Supplier<String> numbers() {
        return () -> RandomStringUtils.random((int)this.size, (int)0, (int)0, (boolean)false, (boolean)true, null, (Random)this.random);
    }

    private Supplier<String> letters() {
        return () -> RandomStringUtils.random((int)this.size, (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)this.random);
    }

    private Supplier<String> alphaNumeric() {
        return () -> RandomStringUtils.random((int)this.size, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.random);
    }

    private Supplier<String> hex() {
        return () -> this.mock.fromStrings(Alphabets.HEXA_STR).stream().val().limit(this.size).collect(Collectors.joining());
    }

    private Supplier<String> specialChars() {
        return () -> this.mock.fromStrings(Alphabets.SPECIAL_CHARACTERS_STR).stream().val().limit(this.size).collect(Collectors.joining());
    }

    @Override
    public Supplier<String> supplier() {
        return () -> RandomStringUtils.random((int)this.size, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.random);
    }
}

