/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.types.enums.MarkovChainType;
import net.andreinc.mockneat.unit.text.markov.MarkovUnit;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Markovs
implements MockUnitString {
    private static final Logger logger = LoggerFactory.getLogger(Markovs.class);
    private final Map<MarkovChainType, MarkovUnit> markovUnits = new EnumMap<MarkovChainType, MarkovUnit>(MarkovChainType.class);
    private final MockNeat mock;
    private int size = 512;

    public Markovs(MockNeat mock) {
        this.mock = mock;
    }

    private MarkovUnit get(MarkovChainType markovChainType) throws IOException {
        if (!this.markovUnits.containsKey((Object)markovChainType)) {
            logger.info("Loading MarkovUnit in memory '{}'.", (Object)markovChainType.getFile());
            this.markovUnits.put(markovChainType, MarkovUnit.internal(this.mock, markovChainType, 2));
        }
        return this.markovUnits.get((Object)markovChainType);
    }

    public Markovs size(int size) {
        Markovs markovs = new Markovs(this.mock);
        markovs.size = size;
        return markovs;
    }

    @Override
    public Supplier<String> supplier() {
        return this.type(MarkovChainType.KAFKA).supplier();
    }

    public MockUnitString types(MarkovChainType ... types) {
        ValidationUtils.notEmptyTypes(types);
        MarkovChainType type = this.mock.from(types).val();
        return this.type(type);
    }

    public MockUnitString type(MarkovChainType type) {
        Validate.notNull((Object)((Object)type), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"type"});
        Supplier<String> supp = () -> {
            MarkovUnit unit = null;
            try {
                unit = this.get(type);
                return unit.generateText(this.size);
            }
            catch (IOException e) {
                logger.error("Cannot load MarkovUnit chain of type '{}'.", (Object)type.name(), (Object)e);
                throw new UncheckedIOException(e);
            }
        };
        return () -> supp;
    }
}

