/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.interfaces.MockUnitValue;
import net.andreinc.mockneat.interfaces.MockValue;
import net.andreinc.mockneat.utils.NamedFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Formatter
implements MockUnitString {
    private final Map<String, MockValue> fields = new HashMap<String, MockValue>();
    private final String fmt;

    private Formatter(String fmt) {
        this.fmt = fmt;
    }

    public static Formatter formatter(String fmt) {
        Validate.notEmpty((CharSequence)fmt, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"fmt"});
        return new Formatter(fmt);
    }

    public <T> Formatter param(String param, MockUnit<T> mock) {
        Validate.notEmpty((CharSequence)param, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"param"});
        Validate.notNull(mock, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mock"});
        Validate.isTrue((boolean)StringUtils.isAlphanumeric((CharSequence)param), (String)"Input param '%s' should be AlphaNumeric.", (Object[])new Object[]{param});
        this.fields.put(param, new MockUnitValue(mock));
        return this;
    }

    @Override
    public Supplier<String> supplier() {
        return () -> {
            Map<String, String> args = this.fields.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((MockValue)e.getValue()).getStr()));
            return NamedFormatUtils.format(this.fmt, args);
        };
    }
}

