/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.seq;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.andreinc.mockneat.interfaces.MockUnitLong;
import org.apache.commons.lang3.Validate;

public class LongSeq
implements MockUnitLong {
    private long increment = 1L;
    private long start = 0L;
    private boolean cycle = true;
    private long max = Long.MAX_VALUE;
    private long min = Long.MIN_VALUE;
    private AtomicLong internal;

    public LongSeq(long start, long increment, long max, long min, boolean cycle) {
        Validate.isTrue((min < max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{min, max});
        this.increment = increment;
        this.start = start;
        this.cycle = cycle;
        this.max = max;
        this.min = min;
        this.internal = new AtomicLong(start);
    }

    public LongSeq(long start, long increment) {
        Validate.isTrue((this.min < this.max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{this.min, this.max});
        this.start = start;
        this.increment = increment;
        this.internal = new AtomicLong(start);
    }

    public LongSeq(long increment) {
        Validate.isTrue((this.min < this.max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{this.min, this.max});
        this.increment = increment;
        this.internal = new AtomicLong(this.start);
    }

    public LongSeq() {
        Validate.isTrue((this.min < this.max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{this.min, this.max});
        this.internal = new AtomicLong(this.start);
    }

    public LongSeq start(long start) {
        this.start = start;
        this.internal = new AtomicLong(start);
        return this;
    }

    public LongSeq increment(long increment) {
        this.increment = increment;
        return this;
    }

    public LongSeq cycle(boolean cycle) {
        this.cycle = cycle;
        return this;
    }

    public LongSeq max(long max) {
        Validate.isTrue((this.min < max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{this.min, max});
        this.max = max;
        return this;
    }

    public LongSeq min(long min) {
        Validate.isTrue((min < this.max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{min, this.max});
        this.min = min;
        return this;
    }

    private boolean nextValueOverflows() {
        return this.increment > 0L ? this.internal.get() > this.max : this.internal.get() < this.min;
    }

    protected void fail() {
        String fmt = String.format("LongSeq overflow. Values are generated inside the interval: [%d, %d]. Cannot increment any further.", this.min, this.max);
        throw new IllegalStateException(fmt);
    }

    @Override
    public Supplier<Long> supplier() {
        return () -> {
            if (this.nextValueOverflows()) {
                if (this.cycle) {
                    this.internal.set(this.start);
                } else {
                    this.fail();
                }
            }
            return this.internal.getAndAdd(this.increment);
        };
    }
}

