/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.andreinc.mockneat.interfaces.MockConstValue;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.interfaces.MockUnitValue;
import net.andreinc.mockneat.interfaces.MockValue;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;

public class Reflect<T>
implements MockUnit<T> {
    private static final Pattern JAVA_FIELD_REGEX = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
    private final Map<String, MockValue> fields = new LinkedHashMap<String, MockValue>();
    private final Class<T> cls;

    public Reflect(Class<T> cls) {
        this.cls = cls;
    }

    @Override
    public Supplier<T> supplier() {
        Validate.notNull(this.cls, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"cls"});
        this.validateFields();
        return () -> {
            T instance = this.instance();
            this.setValues(instance);
            return instance;
        };
    }

    public <T1> Reflect<T> field(String fieldName, MockUnit<T1> mockUnit) {
        Validate.notNull(mockUnit, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mockUnit"});
        this.fields.put(fieldName, new MockUnitValue(mockUnit));
        return this;
    }

    public Reflect<T> field(String fieldName, Object value) {
        this.fields.put(fieldName, MockConstValue.val(value));
        return this;
    }

    public void validateFields() {
        Validate.notNull(this.fields, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"fields"});
        this.fields.forEach((k, v) -> {
            Validate.notEmpty((CharSequence)k, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"fieldName"});
            Validate.isTrue((boolean)JAVA_FIELD_REGEX.matcher((CharSequence)k).matches(), (String)"Field '%s' doesn't match the Java Naming Conventions for fields.", (Object[])new Object[]{k});
            Field field = FieldUtils.getDeclaredField(this.cls, (String)k, (boolean)true);
            if (field == null) {
                String fmt = String.format("Cannot access field: '%s'.", k);
                throw new IllegalArgumentException(fmt);
            }
            boolean isFinal = (field.getModifiers() & 0x10) == 16;
            Validate.isTrue((!isFinal ? 1 : 0) != 0, (String)"Field '%s' is marked as FINAL. It cannot be modified. Please remove it from the fields list.", (Object[])new Object[]{k});
        });
    }

    private T instance() {
        try {
            return this.cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            String fmt = String.format("Cannot create an instance of '%s'. Please verify if the class has a public 'No Arguments' constructor: %s().", this.cls.getSimpleName(), this.cls.getSimpleName());
            throw new IllegalArgumentException(fmt, e);
        }
    }

    private void setValues(T object) {
        this.fields.forEach((key, val) -> {
            Object cVal = val.get();
            try {
                FieldUtils.writeField((Object)object, (String)key, (Object)cVal, (boolean)true);
            }
            catch (IllegalAccessException e) {
                String fmt = String.format("Cannot set field %s.%s with value '%s'. Is the supplied value correct ?", this.cls.getSimpleName(), key, cVal);
                throw new IllegalArgumentException(fmt, e);
            }
        });
    }
}

