/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.interfaces.MockUnitDouble;
import net.andreinc.mockneat.interfaces.MockValue;
import net.andreinc.mockneat.interfaces.MockValueFactory;
import net.andreinc.mockneat.types.Pair;
import org.apache.commons.lang3.Validate;

public class Probabilities<T>
implements MockUnit<T> {
    private final MockNeat mockNeat;
    private final Class<T> cls;
    private final List<Pair<Double, MockValue>> probs = new ArrayList<Pair<Double, MockValue>>();
    private final MockUnitDouble mud;

    public Probabilities(MockNeat mockNeat, Class<T> cls) {
        this.cls = cls;
        this.mockNeat = mockNeat;
        this.mud = mockNeat.doubles().range(0.0, 1.0);
    }

    @Override
    public Supplier<T> supplier() {
        return () -> this.getMock();
    }

    public Probabilities<T> add(Double prob, MockUnit<T> mock) {
        double lastVal = this.lastVal();
        double toAdd = lastVal + prob;
        Validate.isTrue((!(lastVal + prob > 1.0) ? 1 : 0) != 0, (String)"Probabilities sum cannot be bigger (>) than '1.0'.", (Object[])new Object[0]);
        this.probs.add(Pair.of(toAdd, MockValueFactory.value(mock)));
        return this;
    }

    public Probabilities<T> add(Double prob, T obj) {
        double lastVal = this.lastVal();
        double toAdd = lastVal + prob;
        Validate.isTrue((!(lastVal + prob > 1.0) ? 1 : 0) != 0, (String)"Probabilities sum cannot be bigger (>) than '1.0'.", (Object[])new Object[0]);
        this.probs.add(Pair.of(toAdd, MockValueFactory.value(obj)));
        return this;
    }

    private double lastVal() {
        return this.probs.size() == 0 ? 0.0 : this.probs.get(this.probs.size() - 1).getFirst();
    }

    private T getMock() {
        Validate.isTrue((!(this.probs.get(this.probs.size() - 1).getFirst() < 1.0) ? 1 : 0) != 0, (String)"Probabilities sum must be exactly (=) 1.0 when generating values.", (Object[])new Object[0]);
        double rVal = (Double)this.mud.val();
        int i = 0;
        while (this.probs.get(i).getFirst() < rVal) {
            ++i;
        }
        return (T)this.probs.get(i).getSecond().get();
    }
}

