/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.utils.MockUnitUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MethodUtils;

public class Factory<T, FT>
implements MockUnit<T> {
    private static final Pattern JAVA_FIELD_REGEX = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
    private final Class<T> targetClass;
    private final Class<FT> factoryClass;
    private String method;
    private Object[] params;

    public Factory(Class<T> targetClass, Class<FT> factoryClass) {
        this.targetClass = targetClass;
        this.factoryClass = factoryClass;
    }

    public Factory<T, FT> method(String methodName) {
        this.method = methodName;
        return this;
    }

    public Factory<T, FT> params(Object ... params) {
        this.params = params;
        return this;
    }

    @Override
    public Supplier<T> supplier() {
        Validate.notNull(this.targetClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"targetClass"});
        Validate.notNull(this.factoryClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"factoryClass"});
        Validate.notNull((Object)this.params, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"params"});
        Validate.notEmpty((CharSequence)this.method, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"method"});
        Validate.isTrue((boolean)JAVA_FIELD_REGEX.matcher(this.method).matches(), (String)"Method '%s' doesn't match the Java Naming Conventions for methods.", (Object[])new Object[]{this.method});
        Object[] args = new Object[this.params.length];
        return () -> {
            Object result = null;
            try {
                IntStream.range(0, this.params.length).forEach(i -> {
                    args[i] = MockUnitUtils.mockOrObject(this.params[i]);
                });
                result = MethodUtils.invokeExactStaticMethod(this.factoryClass, (String)this.method, (Object[])args);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String fmt = String.format("Cannot invoke '%s.%s()' with params: '%s'.", this.targetClass.getClass().getName(), this.method, MockUnitUtils.listTypes(args));
                throw new IllegalArgumentException(fmt, e);
            }
            return result;
        };
    }
}

