/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.utils.MockUnitUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;

public class Constructor<T>
implements MockUnit<T> {
    private final Class<T> cls;
    private Object[] params;

    public Constructor(Class<T> cls) {
        this.cls = cls;
    }

    public Constructor<T> params(Object ... params) {
        this.params = params;
        return this;
    }

    @Override
    public Supplier<T> supplier() {
        Validate.notNull(this.cls, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"cls"});
        Validate.notNull((Object)this.params, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"params"});
        Object[] args = new Object[this.params.length];
        return () -> {
            IntStream.range(0, this.params.length).forEach(i -> {
                args[i] = MockUnitUtils.mockOrObject(this.params[i]);
            });
            try {
                return ConstructorUtils.invokeConstructor(this.cls, (Object[])args);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                String fmt = String.format("Cannot infer %s%s. Are you sure the constructor exists and it's public ?", this.cls.getName(), MockUnitUtils.listTypes(this.params));
                throw new IllegalArgumentException(fmt, e);
            }
        };
    }
}

