/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.networking;

import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.alphabets.Alphabets;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.utils.LoopsUtils;

public class IPv6s
implements MockUnitString {
    private final MockNeat mock;

    public IPv6s(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<String> supplier() {
        return this::ip;
    }

    private String group() {
        String result = this.mock.from(Alphabets.HEXA_STR).stream().val().limit(4L).collect(Collectors.joining()).replaceAll("([0])\\1", "");
        return result.length() == 0 ? "0" : result;
    }

    private String ip() {
        StringBuilder buff = new StringBuilder("");
        LoopsUtils.loop(8, () -> buff.append(this.group()).append(":"));
        buff.deleteCharAt(buff.length() - 1);
        return buff.toString();
    }
}

