/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.networking;

import java.util.Arrays;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.types.Range;
import net.andreinc.mockneat.types.enums.IPv4Type;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class IPv4s
implements MockUnitString {
    private final MockNeat mock;

    public IPv4s(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<String> supplier() {
        return this.type(IPv4Type.NO_CONSTRAINT).supplier();
    }

    public MockUnitString types(IPv4Type ... types) {
        ValidationUtils.notEmptyTypes(types);
        IPv4Type type = this.mock.from(types).val();
        return this.type(type);
    }

    public MockUnitString type(IPv4Type type) {
        Validate.notNull((Object)((Object)type), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"type"});
        Range[] oc = type.getOctets();
        Supplier<String> supp = () -> {
            StringBuilder buff = new StringBuilder();
            Arrays.stream(oc).forEach(range -> {
                int low = (Integer)range.getLowerBound();
                int up = (Integer)range.getUpperBound();
                if (range.isConstant().booleanValue()) {
                    buff.append(low).append(".");
                } else {
                    int result = (Integer)this.mock.ints().range(low, up + 1).val();
                    buff.append(result).append(".");
                }
            });
            buff.deleteCharAt(buff.length() - 1);
            return buff.toString();
        };
        return () -> supp;
    }
}

