/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.financial;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.types.enums.CreditCardType;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class CreditCards
implements MockUnitString {
    private final MockNeat mock;

    public CreditCards(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<String> supplier() {
        return this.type(CreditCardType.AMERICAN_EXPRESS).supplier();
    }

    public MockUnitString names() {
        return () -> this.mock.dicts().type(DictType.CREDIT_CARD_NAMES)::val;
    }

    public MockUnitString type(CreditCardType type) {
        Validate.notNull((Object)((Object)type), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"type"});
        Supplier<String> supplier = () -> this.generateCreditCard(type);
        return () -> supplier;
    }

    public MockUnitString types(CreditCardType ... types) {
        ValidationUtils.notEmptyTypes(types);
        CreditCardType creditCardType = this.mock.from(types).val();
        return this.type(creditCardType);
    }

    private String generateCreditCard(CreditCardType creditCardType) {
        int arraySize = creditCardType.getLength();
        int cnt = arraySize - 1;
        int[] results = new int[arraySize];
        List<Integer> prefix = this.mock.from(creditCardType.getPrefixes()).val();
        for (int i = 0; i < cnt; ++i) {
            results[i] = i < prefix.size() ? prefix.get(i).intValue() : ((Integer)this.mock.ints().range(0, 10).val()).intValue();
        }
        boolean dblFlag = true;
        int sum = 0;
        while (cnt-- > 0) {
            int dbl;
            sum = dblFlag ? (sum += (dbl = 2 * results[cnt]) > 9 ? dbl % 10 + 1 : dbl) : (sum += results[cnt]);
            dblFlag = !dblFlag;
        }
        results[arraySize - 1] = 9 * sum % 10;
        StringBuilder buff = new StringBuilder();
        Arrays.stream(results).forEach(buff::append);
        return buff.toString();
    }
}

