/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.interfaces;

import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.andreinc.mockneat.interfaces.MockUnit;
import org.apache.commons.lang3.Validate;

public interface MockUnitDouble
extends MockUnit<Double> {
    default public MockUnit<DoubleStream> doubleStream() {
        Supplier<DoubleStream> supp = () -> DoubleStream.generate(((Supplier)this.supplier())::get);
        return () -> supp;
    }

    default public MockUnit<double[]> arrayPrimitive(int size) {
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<double[]> supp = () -> {
            double[] result = new double[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = (Double)this.val();
            });
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Double[]> array(int size) {
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<Double[]> supp = () -> {
            Double[] result = new Double[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = (Double)this.val();
            });
            return result;
        };
        return () -> supp;
    }
}

