/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.interfaces;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.andreinc.mockneat.interfaces.MockUnitDouble;
import net.andreinc.mockneat.interfaces.MockUnitInt;
import net.andreinc.mockneat.interfaces.MockUnitLong;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.utils.LoopsUtils;
import net.andreinc.mockneat.utils.MockUnitUtils;
import org.apache.commons.lang3.Validate;

@FunctionalInterface
public interface MockUnit<T> {
    public Supplier<T> supplier();

    default public T val() {
        return this.supplier().get();
    }

    default public <R> R val(Function<T, R> function) {
        Validate.notNull(function, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"function"});
        return function.apply(this.supplier().get());
    }

    default public void consume(Consumer<T> consumer) {
        Validate.notNull(consumer, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"consumer"});
        consumer.accept(this.val());
    }

    default public String valStr() {
        return this.valStr("");
    }

    default public String valStr(String valueIfNull) {
        T val = this.supplier().get();
        if (null == val) {
            return valueIfNull;
        }
        return val.toString();
    }

    default public <R> MockUnit<R> map(Function<T, R> function) {
        Validate.notNull(function, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"function"});
        Supplier<Object> supp = () -> function.apply(this.supplier().get());
        return () -> supp;
    }

    default public MockUnitInt mapToInt(Function<T, Integer> function) {
        Validate.notNull(function, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"function"});
        Supplier<Integer> supp = () -> (Integer)function.apply(this.val());
        return () -> supp;
    }

    default public MockUnitDouble mapToDouble(Function<T, Double> function) {
        Validate.notNull(function, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"function"});
        Supplier<Double> supp = () -> (Double)function.apply(this.val());
        return () -> supp;
    }

    default public MockUnitLong mapToLong(Function<T, Long> function) {
        Validate.notNull(function, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"function"});
        Supplier<Long> supp = () -> (Long)function.apply(this.val());
        return () -> supp;
    }

    default public MockUnitString mapToString(Function<T, String> function) {
        Validate.notNull(function, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"function"});
        Supplier<String> supp = () -> (String)function.apply(this.val());
        return () -> supp;
    }

    default public MockUnitString mapToString() {
        return () -> this.val()::toString;
    }

    default public MockUnit<Stream<T>> stream() {
        Supplier<Stream> supp = () -> Stream.generate(this.supplier());
        return () -> supp;
    }

    default public MockUnit<List<T>> list(Class<? extends List> listClass, int size) {
        Validate.notNull(listClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"listClass"});
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<List> supp = () -> {
            try {
                List result = (List)listClass.newInstance();
                LoopsUtils.loop(size, () -> MockUnitUtils.add(listClass, result, this.supplier()));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate list '%s'.", listClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<List<T>> list(int size) {
        return this.list(ArrayList.class, size);
    }

    default public MockUnit<Set<T>> set(Class<? extends Set> setClass, int size) {
        Validate.notNull(setClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"setClass"});
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<Set> supp = () -> {
            try {
                Set result = (Set)setClass.newInstance();
                LoopsUtils.loop(size, () -> MockUnitUtils.add(setClass, result, this.supplier()));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate set: '%s'.", setClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Set<T>> set(int size) {
        return this.set(HashSet.class, size);
    }

    default public MockUnit<Collection<T>> collection(Class<? extends Collection> collectionClass, int size) {
        Validate.notNull(collectionClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"collectionClass"});
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<Collection> supp = () -> {
            try {
                Collection result = (Collection)collectionClass.newInstance();
                LoopsUtils.loop(size, () -> MockUnitUtils.add(collectionClass, result, this.supplier()));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate collection: '%s'.", collectionClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Collection<T>> collection(int size) {
        return this.collection(ArrayList.class, size);
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(Class<? extends Map> mapClass, int size, Supplier<R> keysSupplier) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull(keysSupplier, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"keysSupplier"});
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                LoopsUtils.loop(size, () -> this.lambda$null$22(mapClass, result, (Supplier)keysSupplier));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map: '%s'.", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(int size, Supplier<R> keysSupplier) {
        return this.mapKeys(HashMap.class, size, keysSupplier);
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(Class<? extends Map> mapClass, Iterable<R> keys) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull(keys, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"keys"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                keys.forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map: '%s'.", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(Iterable<R> keys) {
        return this.mapKeys(HashMap.class, keys);
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(Class<? extends Map> mapClass, R[] keys) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull(keys, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"keys"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                Arrays.stream(keys).forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map: '%s'.", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(R[] keys) {
        return this.mapKeys(HashMap.class, keys);
    }

    default public MockUnit<Map<Integer, T>> mapKeys(Class<? extends Map> mapClass, int[] keys) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull((Object)keys, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"keys"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                Arrays.stream(keys).forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map: '%s'", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<Integer, T>> mapKeys(int[] keys) {
        return this.mapKeys(HashMap.class, keys);
    }

    default public MockUnit<Map<Long, T>> mapKeys(Class<? extends Map> mapClass, long[] keys) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull((Object)keys, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"keys"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                Arrays.stream(keys).forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map '%s'.", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<Long, T>> mapKeys(long[] keys) {
        return this.mapKeys(HashMap.class, keys);
    }

    default public MockUnit<Map<Double, T>> mapKeys(Class<? extends Map> mapClass, double[] keys) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull((Object)keys, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"keys"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                Arrays.stream(keys).forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map '%s'.", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<Double, T>> mapKeys(double[] keys) {
        return this.mapKeys(HashMap.class, keys);
    }

    default public <R> MockUnit<Map<T, R>> mapVals(Class<? extends Map> mapClass, int size, Supplier<R> valuesSupplier) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull(valuesSupplier, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"valuesSupplier"});
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                LoopsUtils.loop(size, () -> this.lambda$null$40(mapClass, result, (Supplier)valuesSupplier));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map: '%s'.", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<T, R>> mapVals(int size, Supplier<R> valuesSupplier) {
        return this.mapVals(HashMap.class, size, valuesSupplier);
    }

    default public <R> MockUnit<Map<T, R>> mapVals(Class<? extends Map> mapClass, Iterable<R> values) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull(values, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"values"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                values.forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map: '%s'", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<T, R>> mapVals(Iterable<R> values) {
        return this.mapVals(HashMap.class, values);
    }

    default public <R> MockUnit<Map<T, R>> mapVals(Class<? extends Map> mapClass, R[] values) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull(values, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"values"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                Arrays.stream(values).forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map: '%s'", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<T, R>> mapVals(R[] values) {
        return this.mapVals(HashMap.class, values);
    }

    default public MockUnit<Map<T, Integer>> mapVals(Class<? extends Map> mapClass, int[] values) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull((Object)values, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"values"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                Arrays.stream(values).forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map '%s'.", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<T, Integer>> mapVals(int[] values) {
        return this.mapVals(HashMap.class, values);
    }

    default public MockUnit<Map<T, Long>> mapVals(Class<? extends Map> mapClass, long[] values) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull((Object)values, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"values"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                Arrays.stream(values).forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map: '%s'.", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<T, Long>> mapVals(long[] values) {
        return this.mapVals(HashMap.class, values);
    }

    default public MockUnit<Map<T, Double>> mapVals(Class<? extends Map> mapClass, double[] values) {
        Validate.notNull(mapClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"mapClass"});
        Validate.notNull((Object)values, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"values"});
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.newInstance();
                Arrays.stream(values).forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                String fmt = String.format("Cannot instantiate map: '%s'.", mapClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<T, Double>> mapVals(double[] values) {
        return this.mapVals(HashMap.class, values);
    }

    default public MockUnit<T[]> array(Class<T> cls, int size) {
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Validate.notNull(cls, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"cls"});
        Supplier<Object[]> supp = () -> {
            Object[] objs = (Object[])Array.newInstance(cls, size);
            IntStream.range(0, size).forEach(i -> {
                objs[i] = this.supplier().get();
            });
            return objs;
        };
        return () -> supp;
    }

    private /* synthetic */ void lambda$null$40(Class mapClass, Map result, Supplier valuesSupplier) {
        MockUnitUtils.put((Class<? extends Map>)mapClass, result, this.supplier(), valuesSupplier);
    }

    private /* synthetic */ void lambda$null$22(Class mapClass, Map result, Supplier keysSupplier) {
        MockUnitUtils.put((Class<? extends Map>)mapClass, result, keysSupplier, this.supplier());
    }
}

