/*
 * Decompiled with CFR 0.152.
 */
package net.alexandroid.shpref;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.alexandroid.shpref.Contextor;

@SuppressLint(value={"CommitPrefEdits"})
public class ShPref {
    public static final int APPLY = 0;
    public static final int COMMIT = 1;
    public static final String SPECIAL_TAG_FOR_DOUBLES = "specialTagForDoubles";
    private static int sDefaultWriteMode;
    private static SharedPreferences sShPref;
    private static boolean forceApply;
    private static boolean forceCommit;

    public static void init(Context appContext, int defaultWriteMode) {
        Contextor.getInstance().init(appContext);
        sShPref = PreferenceManager.getDefaultSharedPreferences((Context)appContext);
        sDefaultWriteMode = defaultWriteMode;
    }

    public static void setDefaultWriteMode(int defaultWriteMode) {
        sDefaultWriteMode = defaultWriteMode;
    }

    public static boolean contains(@StringRes int key) {
        return ShPref.contains(Contextor.getInstance().getContext().getString(key));
    }

    public static boolean contains(String key) {
        return sShPref.contains(key);
    }

    public static void put(@StringRes int key, Object value) {
        ShPref.put(Contextor.getInstance().getContext().getString(key), value);
    }

    public static void put(String key, Object value) {
        SharedPreferences.Editor editor = sShPref.edit();
        if (value instanceof String || value == null) {
            editor.putString(key, (String)value);
        } else if (value instanceof Integer) {
            editor.putInt(key, ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            editor.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Float) {
            editor.putFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            editor.putLong(key, Double.doubleToRawLongBits((Double)value));
        } else if (value instanceof Long) {
            editor.putLong(key, ((Long)value).longValue());
        } else {
            return;
        }
        if (forceApply || sDefaultWriteMode == 0 && !forceCommit) {
            forceApply = false;
            editor.apply();
        } else {
            forceCommit = false;
            editor.commit();
        }
    }

    public static void putList(String key, List list) {
        if (list == null || list.size() < 1) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ShPref.put(String.format(Locale.ENGLISH, "listKey_%s_%d", key, i), list.get(i));
        }
        ShPref.remove(String.format(Locale.ENGLISH, "listKey_%s_%d", key, list.size()));
    }

    public static void putC(@StringRes int key, Object value) {
        forceCommit = true;
        ShPref.put(Contextor.getInstance().getContext().getString(key), value);
    }

    public static void putC(String key, Object value) {
        forceCommit = true;
        ShPref.put(key, value);
    }

    public static void putA(@StringRes int key, Object value) {
        forceApply = true;
        ShPref.put(Contextor.getInstance().getContext().getString(key), value);
    }

    public static void putA(String key, Object value) {
        forceApply = true;
        ShPref.put(key, value);
    }

    public static String getString(@StringRes int key, String defaultValue) {
        return ShPref.getString(Contextor.getInstance().getContext().getString(key), defaultValue);
    }

    public static String getString(String key, String defaultValue) {
        try {
            return sShPref.getString(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    @Nullable
    public static String getString(@StringRes int key) {
        return ShPref.getString(Contextor.getInstance().getContext().getString(key), null);
    }

    @Nullable
    public static String getString(String key) {
        return ShPref.getString(key, null);
    }

    public static int getInt(@StringRes int key, int defaultValue) {
        return ShPref.getInt(Contextor.getInstance().getContext().getString(key), defaultValue);
    }

    public static int getInt(String key, int defaultValue) {
        try {
            return sShPref.getInt(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static int getInt(@StringRes int key) {
        return ShPref.getInt(Contextor.getInstance().getContext().getString(key), 0);
    }

    public static int getInt(String key) {
        return ShPref.getInt(key, 0);
    }

    public static boolean getBoolean(@StringRes int key, boolean defaultValue) {
        return ShPref.getBoolean(Contextor.getInstance().getContext().getString(key), defaultValue);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        try {
            return sShPref.getBoolean(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(@StringRes int key) {
        return ShPref.getBoolean(Contextor.getInstance().getContext().getString(key), false);
    }

    public static boolean getBoolean(String key) {
        return ShPref.getBoolean(key, false);
    }

    public static float getFloat(@StringRes int key, float defaultValue) {
        return ShPref.getFloat(Contextor.getInstance().getContext().getString(key), defaultValue);
    }

    public static float getFloat(String key, float defaultValue) {
        try {
            return sShPref.getFloat(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static float getFloat(@StringRes int key) {
        return ShPref.getFloat(Contextor.getInstance().getContext().getString(key), 0.0f);
    }

    public static float getFloat(String key) {
        return ShPref.getFloat(key, 0.0f);
    }

    public static double getDouble(@StringRes int key, double defaultValue) {
        return ShPref.getDouble(Contextor.getInstance().getContext().getString(key), defaultValue);
    }

    public static double getDouble(String key, double defaultValue) {
        try {
            return Double.longBitsToDouble(sShPref.getLong(key, Double.doubleToLongBits(defaultValue)));
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static double getDouble(@StringRes int key) {
        return ShPref.getDouble(Contextor.getInstance().getContext().getString(key), 0.0);
    }

    public static double getDouble(String key) {
        return ShPref.getDouble(key, 0.0);
    }

    public static long getLong(@StringRes int key, long defaultValue) {
        return ShPref.getLong(Contextor.getInstance().getContext().getString(key), defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        try {
            return sShPref.getLong(key, defaultValue);
        }
        catch (Resources.NotFoundException e) {
            return defaultValue;
        }
    }

    public static long getLong(@StringRes int key) {
        return ShPref.getLong(Contextor.getInstance().getContext().getString(key), 0L);
    }

    public static long getLong(String key) {
        return ShPref.getLong(key, 0L);
    }

    public static ArrayList<String> getListOfStrings(String key) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        String itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, i);
        while (ShPref.contains(itemKey)) {
            list.add(ShPref.getString(itemKey));
            itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, ++i);
        }
        return list;
    }

    public static ArrayList<Integer> getListOfIntegers(String key) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        String itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, i);
        while (ShPref.contains(itemKey)) {
            list.add(ShPref.getInt(itemKey));
            itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, ++i);
        }
        return list;
    }

    public static ArrayList<Boolean> getListOfBooleans(String key) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        int i = 0;
        String itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, i);
        while (ShPref.contains(itemKey)) {
            list.add(ShPref.getBoolean(itemKey));
            itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, ++i);
        }
        return list;
    }

    public static ArrayList<Float> getListOfFloats(String key) {
        ArrayList<Float> list = new ArrayList<Float>();
        int i = 0;
        String itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, i);
        while (ShPref.contains(itemKey)) {
            list.add(Float.valueOf(ShPref.getFloat(itemKey)));
            itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, ++i);
        }
        return list;
    }

    public static ArrayList<Double> getListOfDoubles(String key) {
        ArrayList<Double> list = new ArrayList<Double>();
        int i = 0;
        String itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, i);
        while (ShPref.contains(itemKey)) {
            list.add(ShPref.getDouble(itemKey));
            itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, ++i);
        }
        return list;
    }

    public static ArrayList<Long> getListOfLongs(String key) {
        ArrayList<Long> list = new ArrayList<Long>();
        int i = 0;
        String itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, i);
        while (ShPref.contains(itemKey)) {
            list.add(ShPref.getLong(itemKey));
            itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, ++i);
        }
        return list;
    }

    public static ArrayList getMixedList(String key) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        String itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, i);
        while (ShPref.contains(itemKey)) {
            Object obj = ShPref.get(itemKey);
            list.add(obj);
            itemKey = String.format(Locale.ENGLISH, "listKey_%s_%d", key, ++i);
        }
        return list;
    }

    public static Object get(String itemKey) {
        Map all = sShPref.getAll();
        Object object = all.get(itemKey);
        if (object instanceof String) {
            return ShPref.getString(itemKey);
        }
        if (object instanceof Integer) {
            return ShPref.getInt(itemKey);
        }
        if (object instanceof Boolean) {
            return ShPref.getBoolean(itemKey);
        }
        if (object instanceof Float) {
            return Float.valueOf(ShPref.getFloat(itemKey));
        }
        if (object instanceof Long) {
            return ShPref.getLong(itemKey);
        }
        return null;
    }

    public static void remove(@StringRes int key) {
        ShPref.remove(Contextor.getInstance().getContext().getString(key));
    }

    public static void remove(String key) {
        SharedPreferences.Editor editor = sShPref.edit().remove(key);
        if (forceApply || sDefaultWriteMode == 0 && !forceCommit) {
            forceApply = false;
            editor.apply();
        } else {
            forceCommit = false;
            editor.commit();
        }
    }

    public static void removeList(String key) {
        ShPref.remove(String.format(Locale.ENGLISH, "listKey_%s_%d", key, 0));
    }

    public static void removeA(@StringRes int key) {
        forceApply = true;
        ShPref.remove(Contextor.getInstance().getContext().getString(key));
    }

    public static void removeA(String key) {
        forceApply = true;
        ShPref.remove(key);
    }

    public static void removeC(@StringRes int key) {
        forceCommit = true;
        ShPref.remove(Contextor.getInstance().getContext().getString(key));
    }

    public static void removeC(String key) {
        forceCommit = true;
        ShPref.remove(key);
    }

    public static void clear() {
        sShPref.edit().clear().commit();
    }

    static /* synthetic */ SharedPreferences access$000() {
        return sShPref;
    }

    public static class Editor {
        private SharedPreferences.Editor editor = ShPref.access$000().edit();

        public Editor put(@StringRes int key, Object value) {
            return this.put(Contextor.getInstance().getContext().getString(key), value);
        }

        public Editor put(String key, Object value) {
            if (value instanceof String) {
                this.editor.putString(key, (String)value);
            } else if (value instanceof Integer) {
                this.editor.putInt(key, ((Integer)value).intValue());
            } else if (value instanceof Boolean) {
                this.editor.putBoolean(key, ((Boolean)value).booleanValue());
            } else if (value instanceof Float) {
                this.editor.putFloat(key, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                this.editor.putLong(key, Double.doubleToRawLongBits((Double)value));
            } else if (value instanceof Long) {
                this.editor.putLong(key, ((Long)value).longValue());
            }
            return this;
        }

        public Editor remove(@StringRes int key) {
            return this.remove(Contextor.getInstance().getContext().getString(key));
        }

        public Editor remove(String key) {
            this.editor.remove(key);
            return this;
        }

        public void commit() {
            this.editor.commit();
        }

        public void apply() {
            this.editor.apply();
        }
    }
}

