/*
 * Decompiled with CFR 0.152.
 */
package net.alexandroid.gps;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.location.LocationManager;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import java.lang.ref.WeakReference;

public class GpsStatusDetector {
    private static final int REQUEST_CODE = 2;
    private WeakReference<Activity> mActivityWeakReference;
    private WeakReference<GpsStatusDetectorCallBack> mCallBackWeakReference;

    public GpsStatusDetector(Activity activity) {
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
        this.mCallBackWeakReference = new WeakReference<GpsStatusDetectorCallBack>((GpsStatusDetectorCallBack)activity);
    }

    public GpsStatusDetector(Fragment fragment) {
        this.mActivityWeakReference = new WeakReference<FragmentActivity>(fragment.getActivity());
        this.mCallBackWeakReference = new WeakReference<GpsStatusDetectorCallBack>((GpsStatusDetectorCallBack)fragment);
    }

    public void checkGpsStatus() {
        Activity activity = (Activity)this.mActivityWeakReference.get();
        GpsStatusDetectorCallBack callBack = (GpsStatusDetectorCallBack)this.mCallBackWeakReference.get();
        if (activity == null || callBack == null) {
            return;
        }
        if (this.isGpsEnabled(activity)) {
            callBack.onGpsSettingStatus(true);
        } else {
            this.setLocationRequest(activity, callBack);
        }
    }

    private boolean isGpsEnabled(Activity activity) {
        return ((LocationManager)activity.getSystemService("location")).isProviderEnabled("gps");
    }

    private void setLocationRequest(final Activity activity, final GpsStatusDetectorCallBack callBack) {
        final GoogleApiClient mGoogleApiClient = new GoogleApiClient.Builder((Context)activity).addApi(LocationServices.API).build();
        mGoogleApiClient.connect();
        LocationRequest locationRequest = LocationRequest.create().setPriority(100).setInterval(30000L).setFastestInterval(5000L);
        LocationSettingsRequest locationSettingsRequest = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest).setAlwaysShow(true).build();
        PendingResult result = LocationServices.SettingsApi.checkLocationSettings(mGoogleApiClient, locationSettingsRequest);
        result.setResultCallback((ResultCallback)new ResultCallback<LocationSettingsResult>(){

            public void onResult(@NonNull LocationSettingsResult result) {
                Status status = result.getStatus();
                switch (status.getStatusCode()) {
                    case 0: {
                        callBack.onGpsSettingStatus(true);
                        break;
                    }
                    case 6: {
                        try {
                            status.startResolutionForResult(activity, 2);
                        }
                        catch (IntentSender.SendIntentException e) {
                            callBack.onGpsSettingStatus(false);
                        }
                        break;
                    }
                    case 8502: {
                        callBack.onGpsSettingStatus(false);
                    }
                }
                mGoogleApiClient.disconnect();
            }
        });
    }

    public void checkOnActivityResult(int requestCode, int resultCode) {
        Activity activity = (Activity)this.mActivityWeakReference.get();
        GpsStatusDetectorCallBack callBack = (GpsStatusDetectorCallBack)this.mCallBackWeakReference.get();
        if (activity == null || callBack == null) {
            return;
        }
        if (requestCode == 2) {
            if (resultCode == -1) {
                callBack.onGpsSettingStatus(true);
            } else {
                callBack.onGpsSettingStatus(false);
                callBack.onGpsAlertCanceledByUser();
            }
        }
    }

    public static interface GpsStatusDetectorCallBack {
        public void onGpsSettingStatus(boolean var1);

        public void onGpsAlertCanceledByUser();
    }
}

