/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb;

import java.util.Collection;
import metrics_influxdb.JsonBuilder;

class JsonBuilderDefault
implements JsonBuilder {
    private final StringBuilder json = new StringBuilder();
    private boolean hasSeriesData;

    JsonBuilderDefault() {
    }

    @Override
    public boolean hasSeriesData() {
        return this.hasSeriesData;
    }

    @Override
    public void reset() {
        this.json.setLength(0);
        this.json.append('[');
        this.hasSeriesData = false;
    }

    @Override
    public String toJsonString() {
        this.json.append(']');
        String str = this.json.toString();
        this.json.setLength(this.json.length() - 1);
        return str;
    }

    @Override
    public void appendSeries(String namePrefix, String name, String nameSuffix, String[] columns, Object[][] points) {
        int i;
        this.hasSeriesData = true;
        if (this.json.length() > 1) {
            this.json.append(',');
        }
        this.json.append("{\"name\":\"").append(namePrefix).append(name).append(nameSuffix).append("\",\"columns\":[");
        for (i = 0; i < columns.length; ++i) {
            if (i > 0) {
                this.json.append(',');
            }
            this.json.append('\"').append(columns[i]).append('\"');
        }
        this.json.append("],\"points\":[");
        for (i = 0; i < points.length; ++i) {
            if (i > 0) {
                this.json.append(',');
            }
            Object[] row = points[i];
            this.json.append('[');
            for (int j = 0; j < row.length; ++j) {
                Object value;
                if (j > 0) {
                    this.json.append(',');
                }
                if ((value = row[j]) instanceof String) {
                    this.json.append('\"').append(value).append('\"');
                    continue;
                }
                if (value instanceof Collection && ((Collection)value).size() < 1) {
                    this.json.append("null");
                    continue;
                }
                this.json.append(value);
            }
            this.json.append(']');
        }
        this.json.append("]}");
    }

    public String toString() {
        return this.json.toString();
    }
}

