/*
 * Decompiled with CFR 0.152.
 */
package metrics_influxdb;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.JsonBuilder;
import metrics_influxdb.JsonBuilderDefault;

public class Influxdb {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public final URL url;
    public boolean debugJson = false;
    public JsonBuilder jsonBuilder = new JsonBuilderDefault();

    public static String toTimePrecision(TimeUnit t) {
        switch (t) {
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MICROSECONDS: {
                return "u";
            }
        }
        throw new IllegalArgumentException("time precision should be SECONDS or MILLISECONDS or MICROSECONDS");
    }

    public Influxdb(String host, int port, String database, String username, String password) throws Exception {
        this(host, port, database, username, password, TimeUnit.MILLISECONDS);
    }

    public Influxdb(String host, int port, String database, String username, String password, TimeUnit timePrecision) throws Exception {
        this.url = new URL("http", host, port, "/db/" + database + "/series?u=" + URLEncoder.encode(username, UTF_8.name()) + "&p=" + password + "&time_precision=" + Influxdb.toTimePrecision(timePrecision));
    }

    public Influxdb(URL url) throws Exception {
        this.url = url;
    }

    public boolean hasSeriesData() {
        return this.jsonBuilder.hasSeriesData();
    }

    public void resetRequest() {
        this.jsonBuilder.reset();
    }

    public void appendSeries(String namePrefix, String name, String nameSuffix, String[] columns, Object[][] points) {
        this.jsonBuilder.appendSeries(namePrefix, name, nameSuffix, columns, points);
    }

    public int sendRequest(boolean throwExc, boolean printJson) throws Exception {
        String json = this.jsonBuilder.toJsonString();
        if (printJson || this.debugJson) {
            System.err.println("----");
            System.err.println(json);
            System.err.println("----");
        }
        HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        OutputStream wr = con.getOutputStream();
        wr.write(json.getBytes(UTF_8));
        wr.flush();
        wr.close();
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            con.getInputStream().close();
        } else if (throwExc) {
            throw new IOException("Server returned HTTP response code: " + responseCode + "for URL: " + this.url + " with content :'" + con.getResponseMessage() + "'");
        }
        return responseCode;
    }
}

