/*
 * Decompiled with CFR 0.152.
 */
package name.gudong.loading;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import name.gudong.loading.ILoading;
import name.gudong.loading.LoadingDrawable;

public class LoadingView
extends ImageView
implements ILoading {
    private static final int default_max = 100;
    private int max = 100;
    private boolean isAutoAnim = true;
    private LoadingDrawable mDrawable;

    public LoadingView(Context context) {
        this(context, null);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mDrawable = new LoadingDrawable(context);
        if (this.getDrawable() != null) {
            this.mDrawable.setLoadingDrawable(this.getDrawable());
        }
        this.setImageDrawable(this.mDrawable);
    }

    public void setIsAutoPlayAnim(boolean flag) {
        this.isAutoAnim = flag;
    }

    public boolean isAutoAnim() {
        return this.isAutoAnim;
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (!this.isAutoAnim()) {
            return;
        }
        if (visibility == 0) {
            this.start();
        } else {
            this.stop();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    @Override
    public void setDuration(int duration) {
        this.mDrawable.setDuration(duration);
    }

    @Override
    public void setDivideCount(int divideCount) {
        this.mDrawable.setDivideCount(divideCount);
    }

    @Override
    public void setLoadingDrawable(int resDrawable) {
        this.mDrawable.setLoadingDrawable(resDrawable);
    }

    public void start() {
        this.mDrawable.start();
    }

    public void stop() {
        this.mDrawable.stop();
    }

    public boolean isRunning() {
        return this.mDrawable.isRunning();
    }

    public void setMax(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("max value must bigger than 0");
        }
        this.max = max;
    }

    public void setProgress(int progress) {
        if (this.isAutoAnim) {
            throw new IllegalStateException("please make auto anim flag as false, use setIsAutoPlayAnim method");
        }
        if (this.max != 0) {
            int degree = (int)(360.0f * ((float)progress / (float)this.max));
            this.mDrawable.setCurrentDegree(degree);
        }
    }
}

