/*
 * Decompiled with CFR 0.152.
 */
package name.gudong.loading;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import java.lang.ref.WeakReference;
import name.gudong.loading.ILoading;
import name.gudong.loading.R;

public class LoadingDrawable
extends Drawable
implements ILoading {
    private static final int default_step = 30;
    private static final int default_duration = 100;
    private Context mContext;
    private Handler mHandler;
    private int alpha;
    private Bitmap mSource;
    private Matrix mMatrix = new Matrix();
    private int mRotateStep = 30;
    private int mDuration = 100;
    private int mCurrentDegree = 0;
    private float mScaleY = 1.0f;
    private float mScaleX = 1.0f;
    private int mOffset = -1;
    private int mCenterXY;
    private boolean isAnimRunning = false;
    private LoadingTask mLoadingTask;

    public LoadingDrawable(Context context) {
        this(context, R.drawable.loading_drawable);
    }

    public LoadingDrawable(Context context, int resDrawable) {
        this.mContext = context;
        this.mSource = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resDrawable);
        this.mHandler = new Handler();
        this.mLoadingTask = new LoadingTask(this);
    }

    private void doRotateLoading(int degree) {
        this.mMatrix.reset();
        this.mMatrix.postScale(this.mScaleX, this.mScaleY);
        if (this.mOffset >= 0) {
            this.mMatrix.postTranslate((float)this.mOffset, (float)this.mOffset);
        }
        this.mMatrix.postRotate((float)degree, (float)this.mCenterXY, (float)this.mCenterXY);
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        canvas.save();
        canvas.translate((float)this.getBounds().left, (float)this.getBounds().top);
        canvas.drawBitmap(this.mSource, this.mMatrix, null);
        canvas.restore();
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getOpacity() {
        return -1;
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public void start() {
        if (!this.isRunning()) {
            this.mHandler.post((Runnable)this.mLoadingTask);
            this.isAnimRunning = true;
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.mHandler.removeCallbacks((Runnable)this.mLoadingTask);
            this.isAnimRunning = false;
        }
    }

    public boolean isRunning() {
        return this.isAnimRunning;
    }

    protected void onBoundsChange(Rect drawBounds) {
        super.onBoundsChange(drawBounds);
        int w = drawBounds.width();
        int h = drawBounds.height();
        this.onSizeChanged(w, h, this.mSource.getWidth(), this.mSource.getHeight());
    }

    private void onSizeChanged(int w, int h, int drawableWidth, int drawableHeight) {
        if (w != h) {
            throw new IllegalStateException("view must have same width and height, now w = " + w + " h =" + h);
        }
        this.mCenterXY = w / 2;
        if (drawableWidth != drawableHeight) {
            throw new IllegalStateException("drawable must have same width and height, now drawableWidth = " + drawableWidth + " drawableHeight=" + drawableHeight);
        }
        if (w <= drawableWidth) {
            this.mScaleY = (float)h / (float)drawableWidth;
            this.mScaleX = (float)w / (float)drawableHeight;
        } else {
            this.mOffset = (w - drawableWidth) / 2;
        }
        this.initLoadingStatus();
    }

    private void initLoadingStatus() {
        this.setCurrentDegree(0);
    }

    @Override
    public void setLoadingDrawable(int resDrawable) {
        this.mSource = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resDrawable);
    }

    public void setLoadingDrawable(Drawable drawable2) {
        this.mSource = this.drawableToBitmap(drawable2);
    }

    @Override
    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    @Override
    public void setRotateStep(int rotateStep) {
        this.mRotateStep = rotateStep;
    }

    public int getIntrinsicWidth() {
        return this.mSource.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.mSource.getHeight();
    }

    public void setCurrentDegree(int currentDegree) {
        this.mCurrentDegree = currentDegree;
        this.doRotateLoading(currentDegree);
    }

    private Bitmap drawableToBitmap(Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap = null;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private static class LoadingTask
    implements Runnable {
        WeakReference<LoadingDrawable> mWeakDrawable;

        LoadingTask(LoadingDrawable drawable2) {
            this.mWeakDrawable = new WeakReference<LoadingDrawable>(drawable2);
        }

        @Override
        public void run() {
            LoadingDrawable mDrawable = (LoadingDrawable)this.mWeakDrawable.get();
            if (mDrawable == null) {
                return;
            }
            LoadingDrawable loadingDrawable = mDrawable;
            loadingDrawable.mCurrentDegree = loadingDrawable.mCurrentDegree + mDrawable.mRotateStep;
            if (mDrawable.mCurrentDegree >= 360) {
                mDrawable.mCurrentDegree = 0;
            }
            mDrawable.doRotateLoading(mDrawable.mCurrentDegree);
            mDrawable.mHandler.postDelayed((Runnable)this, (long)mDrawable.mDuration);
        }
    }
}

