/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.interceptor;

import mx4j.adaptor.interceptor.AdaptorInterceptor;
import mx4j.adaptor.interceptor.Invocation;
import mx4j.log.Logger;

public class TimingAdaptorInterceptor
extends AdaptorInterceptor {
    private ThreadLocal m_time = new ThreadLocal();

    protected void preInvoke(Invocation invocation) throws Exception {
        this.m_time.set(new Long(System.currentTimeMillis()));
    }

    protected void postInvoke(Invocation invocation) throws Exception {
        long end = System.currentTimeMillis();
        long invocationTime = end - (Long)this.m_time.get();
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("Invocation time: " + invocationTime);
        }
    }

    public String getType() {
        return "timing";
    }
}

