/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.rmi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import mx4j.adaptor.interceptor.Interceptor;
import mx4j.adaptor.rmi.RMIAdaptorMBean;

public abstract class RMIAdaptor
implements RMIAdaptorMBean,
MBeanRegistration {
    private MBeanServer m_server;
    private ObjectName m_objectName;
    private String m_jndiName;
    private Properties m_namingProperties = new Properties();
    private ArrayList m_interceptors = new ArrayList();

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.m_server = server;
        this.m_objectName = name == null ? this.getDefaultObjectName() : name;
        return this.m_objectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    public String getJNDIName() {
        return this.m_jndiName;
    }

    public void setJNDIName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while running");
        }
        this.m_jndiName = name;
    }

    public void putNamingProperty(Object property, Object value) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while running");
        }
        ((Hashtable)this.m_namingProperties).put(property, value);
    }

    public void clearNamingProperties() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while running");
        }
        ((Hashtable)this.m_namingProperties).clear();
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ignored) {
            return "localhost";
        }
    }

    public void addInterceptor(Interceptor interceptor) {
        if (interceptor != null) {
            this.m_interceptors.add(interceptor);
        }
    }

    public void setMBeanServer(MBeanServer server) {
        this.m_server = server;
    }

    protected List getInterceptors() {
        return this.m_interceptors;
    }

    public Properties getNamingProperties() {
        return (Properties)((Hashtable)this.m_namingProperties).clone();
    }

    protected MBeanServer getMBeanServer() {
        return this.m_server;
    }

    protected ObjectName getObjectName() {
        return this.m_objectName;
    }

    protected abstract ObjectName getDefaultObjectName() throws MalformedObjectNameException;

    protected void bind(Object adaptor) throws NamingException {
        InitialContext context = null;
        Properties properties = this.getNamingProperties();
        if (((Hashtable)properties).size() != 0) {
            context = new InitialContext(properties);
        } else {
            context = new InitialContext();
            Hashtable<?, ?> env = context.getEnvironment();
            Iterator<Map.Entry<?, ?>> i = env.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<?, ?> entry = i.next();
                this.putNamingProperty(entry.getKey(), entry.getValue());
            }
        }
        context.bind(this.getJNDIName(), adaptor);
    }

    protected void unbind() throws NamingException {
        InitialContext context = null;
        Properties properties = this.getNamingProperties();
        context = ((Hashtable)properties).size() != 0 ? new InitialContext(properties) : new InitialContext();
        context.unbind(this.getJNDIName());
    }

    public abstract boolean isRunning();

    public abstract void stop() throws Exception;

    public abstract void start() throws Exception;
}

