/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.interceptor;

import javax.management.ObjectName;
import mx4j.adaptor.interceptor.AdaptorInterceptorMBean;
import mx4j.adaptor.interceptor.Interceptor;
import mx4j.adaptor.interceptor.Invocation;
import mx4j.adaptor.interceptor.InvocationResult;
import mx4j.log.Log;
import mx4j.log.Logger;

public class AdaptorInterceptor
implements Interceptor,
AdaptorInterceptorMBean {
    private Interceptor m_nextInterceptor;
    private boolean m_enabled;
    private ObjectName m_name;

    public void setNext(Interceptor interceptor) {
        this.m_nextInterceptor = interceptor;
    }

    protected Interceptor getNext() {
        return this.m_nextInterceptor;
    }

    public void setObjectName(ObjectName name) {
        this.m_name = name;
    }

    public ObjectName getObjectName() {
        return this.m_name;
    }

    protected void preInvoke(Invocation invocation) throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InvocationResult invoke(Invocation invocation) throws Exception {
        InvocationResult invocationResult;
        boolean trace;
        Logger logger;
        block17: {
            logger = this.getLogger();
            trace = logger.isEnabledFor(0);
            boolean debug = logger.isEnabledFor(10);
            boolean isEnabled = this.isEnabled();
            if (debug) {
                logger.debug("Adaptor Interceptor '" + this.getType() + "' is enabled: " + isEnabled);
            }
            try {
                if (isEnabled) {
                    if (trace) {
                        logger.trace("preInvoke invocation...");
                    }
                    try {
                        this.preInvoke(invocation);
                    }
                    catch (Exception x) {
                        logger.error("preInvoke invocation exception", x);
                        throw x;
                    }
                    if (trace) {
                        logger.trace("preInvoke invocation completed with no exceptions");
                    }
                }
                if (trace) {
                    logger.trace("doInvoke invocation...");
                }
                InvocationResult result = null;
                try {
                    result = this.doInvoke(invocation);
                }
                catch (Exception x) {
                    logger.error("doInvoke invocation exception", x);
                    throw x;
                }
                if (trace) {
                    logger.trace("doInvoke invocation completed with no exceptions");
                }
                if (debug) {
                    logger.debug("Result is: " + result);
                }
                invocationResult = result;
                Object var9_10 = null;
                if (!isEnabled) return invocationResult;
                if (!trace) break block17;
                logger.trace("postInvoke invocation...");
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (!isEnabled) throw throwable;
                if (trace) {
                    logger.trace("postInvoke invocation...");
                }
                try {
                    this.postInvoke(invocation);
                }
                catch (Exception x) {
                    logger.error("postInvoke invocation exception", x);
                    throw x;
                }
                if (!trace) throw throwable;
                logger.trace("postInvoke invocation completed with no exceptions");
                throw throwable;
            }
        }
        try {
            this.postInvoke(invocation);
        }
        catch (Exception x) {
            logger.error("postInvoke invocation exception", x);
            throw x;
        }
        if (!trace) return invocationResult;
        logger.trace("postInvoke invocation completed with no exceptions");
        return invocationResult;
    }

    protected InvocationResult doInvoke(Invocation invocation) throws Exception {
        return this.getNext().invoke(invocation);
    }

    protected void postInvoke(Invocation invocation) throws Exception {
    }

    public String getType() {
        return "standard";
    }

    public void setEnabled(boolean value) {
        this.m_enabled = value;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    protected Logger getLogger() {
        return Log.getLogger("jmx.mbean." + this.getClass().getName());
    }

    public String toString() {
        return "Adaptor interceptor [" + this.getType() + "]";
    }
}

