/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import mx4j.adaptor.http.HttpCommandProcessor;
import mx4j.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ServerByDomainCommandProcessor
implements HttpCommandProcessor {
    private MBeanServer server;
    private DocumentBuilder builder;

    public ServerByDomainCommandProcessor(MBeanServer server, DocumentBuilder builder) {
        this.server = server;
        this.builder = builder;
    }

    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        Element root = document.createElement("Server");
        document.appendChild(root);
        String targetClass = in.getVariable("instanceof");
        String queryNames = in.getVariable("querynames");
        ObjectName query = null;
        if (queryNames != null) {
            try {
                query = new ObjectName(queryNames);
            }
            catch (MalformedObjectNameException e) {
                Element exceptionElement = document.createElement("Exception");
                exceptionElement.setAttribute("errorMsg", e.getMessage());
                root.appendChild(exceptionElement);
                return document;
            }
        }
        Set<ObjectInstance> mbeans = this.server.queryMBeans(query, null);
        Iterator<ObjectInstance> i = mbeans.iterator();
        HashMap domains = new HashMap();
        while (i.hasNext()) {
            ObjectInstance instance = i.next();
            ObjectName name = instance.getObjectName();
            String domain = name.getDomain();
            if (domains.containsKey(domain)) {
                ((List)domains.get(domain)).add(name);
                continue;
            }
            ArrayList<ObjectName> objects = new ArrayList<ObjectName>();
            objects.add(name);
            domains.put(domain, objects);
        }
        i = domains.keySet().iterator();
        while (i.hasNext()) {
            String domain = (String)((Object)i.next());
            Element domainElement = document.createElement("Domain");
            root.appendChild(domainElement);
            domainElement.setAttribute("name", domain);
            List names = (List)domains.get(domain);
            Iterator j = names.iterator();
            while (j.hasNext()) {
                ObjectName targetName = (ObjectName)j.next();
                if (targetClass != null && !this.server.isInstanceOf(targetName, targetClass)) continue;
                Element mBeanElement = document.createElement("MBean");
                mBeanElement.setAttribute("objectname", targetName.toString());
                MBeanInfo info = this.server.getMBeanInfo(targetName);
                mBeanElement.setAttribute("description", info.getDescription());
                mBeanElement.setAttribute("classname", info.getClassName());
                domainElement.appendChild(mBeanElement);
            }
        }
        return document;
    }
}

