/*
 * Decompiled with CFR 0.152.
 */
package mx4j.examples.tools.adaptor.http;

import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import mx4j.tools.adaptor.ssl.SSLAdaptorServerSocketFactoryMBean;

public class SSLHttpAdaptor {
    private int port = 8080;
    private String host = "localhost";
    private String path = null;
    private String pathInJar = null;
    static /* synthetic */ Class class$mx4j$tools$adaptor$ssl$SSLAdaptorServerSocketFactoryMBean;

    public SSLHttpAdaptor(String[] args) {
        if (args.length > 0) {
            this.host = args[0];
        }
        if (args.length > 1) {
            this.port = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            this.path = args[2];
        }
        if (args.length > 3) {
            this.pathInJar = args[3];
        }
    }

    public void start() throws JMException {
        MBeanServer server = MBeanServerFactory.createMBeanServer("test");
        ObjectName serverName = new ObjectName("Http:name=HttpAdaptor");
        server.createMBean("mx4j.tools.adaptor.http.HttpAdaptor", serverName, null);
        if (this.port > 0) {
            server.setAttribute(serverName, new Attribute("Port", new Integer(this.port)));
        } else {
            System.out.println("Incorrect port value " + this.port);
        }
        if (this.host != null) {
            server.setAttribute(serverName, new Attribute("Host", this.host));
        } else {
            System.out.println("Incorrect null hostname");
        }
        ObjectName processorName = new ObjectName("Http:name=XSLTProcessor");
        server.createMBean("mx4j.tools.adaptor.http.XSLTProcessor", processorName, null);
        if (this.path != null) {
            server.setAttribute(processorName, new Attribute("File", this.path));
        }
        server.setAttribute(processorName, new Attribute("UseCache", new Boolean(false)));
        if (this.pathInJar != null) {
            server.setAttribute(processorName, new Attribute("PathInJar", this.pathInJar));
        }
        server.setAttribute(serverName, new Attribute("ProcessorName", processorName));
        TestClass test1 = new TestClass("t1");
        TestClass test2 = new TestClass("t2");
        server.registerMBean(test1, new ObjectName("Test:name=test1"));
        server.registerMBean(test2, new ObjectName("Test:name=test2"));
        ObjectName sslFactory = new ObjectName("Adaptor:service=SSLServerSocketFactory");
        server.createMBean("mx4j.tools.adaptor.ssl.SSLAdaptorServerSocketFactory", sslFactory, null);
        SSLAdaptorServerSocketFactoryMBean factory = (SSLAdaptorServerSocketFactoryMBean)MBeanServerInvocationHandler.newProxyInstance(server, sslFactory, class$mx4j$tools$adaptor$ssl$SSLAdaptorServerSocketFactoryMBean == null ? (class$mx4j$tools$adaptor$ssl$SSLAdaptorServerSocketFactoryMBean = SSLHttpAdaptor.class$("mx4j.tools.adaptor.ssl.SSLAdaptorServerSocketFactoryMBean")) : class$mx4j$tools$adaptor$ssl$SSLAdaptorServerSocketFactoryMBean, false);
        factory.setKeyStoreName("certs");
        factory.setKeyStorePassword("mx4j");
        server.setAttribute(serverName, new Attribute("SocketFactoryName", sslFactory));
        server.invoke(serverName, "start", null, null);
    }

    public static void main(String[] str) throws JMException {
        SSLHttpAdaptor adaptor = new SSLHttpAdaptor(str);
        adaptor.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TestClass
    extends NotificationBroadcasterSupport
    implements TestClassMBean {
        private String str;

        public TestClass(String str) {
            this.str = str;
        }

        public String getStr() {
            return this.str;
        }

        public void setStr(String str) {
            this.str = str;
        }

        public Double getDouble() {
            return new Double(0.0);
        }

        public boolean isTrue() {
            return true;
        }

        public Boolean aMethod(String string) {
            return new Boolean(string.equals("true"));
        }

        public void anotherMethod(String string, int test) {
            this.str = string;
        }

        public MBeanNotificationInfo[] getNotificationInfo() {
            MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"test1", "test2"}, "name", "test")};
            return notifications;
        }
    }

    private static interface TestClassMBean {
        public String getStr();

        public Double getDouble();

        public boolean isTrue();

        public void setStr(String var1);

        public Boolean aMethod(String var1);

        public void anotherMethod(String var1, int var2);
    }
}

