/*
 * Decompiled with CFR 0.152.
 */
package mx4j.examples.services.relation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.Role;
import javax.management.relation.RoleList;
import javax.management.relation.RoleResult;
import mx4j.examples.services.relation.SimplePersonalLibrary;
import mx4j.log.Log;
import mx4j.log.Logger;

public class RelationServiceExample {
    private MBeanServer m_server = MBeanServerFactory.createMBeanServer("RelationExample");
    private RelationServiceMBean m_proxy = null;
    private String m_relationServiceClass = "javax.management.relation.RelationService";
    private String m_libraryClassName = "mx4j.examples.services.relation.SimplePersonalLibrary";
    private ObjectName m_libraryObjectName = null;
    private ObjectName m_relationObjectName = null;
    private SimplePersonalLibrary m_library = null;
    static /* synthetic */ Class class$javax$management$relation$RelationServiceMBean;

    public void setUpRelations() {
        try {
            System.out.println("Creating RelationService in the MBeanServer");
            Object[] params = new Object[]{new Boolean(true)};
            String[] signature = new String[]{"boolean"};
            this.m_relationObjectName = new ObjectName("relations:class=" + this.m_relationServiceClass);
            this.m_server.createMBean(this.m_relationServiceClass, this.m_relationObjectName, null, params, signature);
            this.m_proxy = (RelationServiceMBean)MBeanServerInvocationHandler.newProxyInstance(this.m_server, this.m_relationObjectName, class$javax$management$relation$RelationServiceMBean == null ? (class$javax$management$relation$RelationServiceMBean = RelationServiceExample.class$("javax.management.relation.RelationServiceMBean")) : class$javax$management$relation$RelationServiceMBean, false);
            System.out.println("----------------------- done ----------------------------");
            System.out.println("create the relationType");
            String libraryTypeName = "personal_library";
            this.m_library = new SimplePersonalLibrary(libraryTypeName);
            this.addRelationType();
            this.printRelationTypeInfo();
            System.out.println("----------------------- done ----------------------------");
            System.out.println("create RelationId for the relationType");
            String personalLibraryId = libraryTypeName + "_internal";
            System.out.println("----------------------- done ----------------------------");
            String ownerClassName = "mx4j.examples.services.relation.SimpleOwner";
            String bookClassName = "mx4j.examples.services.relation.SimpleBooks";
            System.out.println("Creating MBeans to represent our relations");
            ObjectName ownerName1 = new ObjectName("library:name=" + ownerClassName + "1");
            ObjectName ownerName2 = new ObjectName("library:name=" + ownerClassName + "2");
            ObjectName bookName1 = new ObjectName("library:name=" + bookClassName + "1");
            ObjectName bookName2 = new ObjectName("library:name=" + bookClassName + "2");
            ObjectName bookName3 = new ObjectName("library:name=" + bookClassName + "3");
            ObjectName bookName4 = new ObjectName("library:name=" + bookClassName + "4");
            ObjectName bookName5 = new ObjectName("library:name=" + bookClassName + "5");
            this.m_server.createMBean(bookClassName, bookName1, null, new Object[]{"Lord of the rings"}, new String[]{"java.lang.String"});
            this.m_server.createMBean(bookClassName, bookName2, null, new Object[]{"The Hobbit"}, new String[]{"java.lang.String"});
            this.m_server.createMBean(bookClassName, bookName3, null, new Object[]{"Harry Potter"}, new String[]{"java.lang.String"});
            this.m_server.createMBean(bookClassName, bookName4, null, new Object[]{"UML Distilled"}, new String[]{"java.lang.String"});
            this.m_server.createMBean(bookClassName, bookName5, null, new Object[]{"Applying UML"}, new String[]{"java.lang.String"});
            this.m_server.createMBean(ownerClassName, ownerName1, null, new Object[]{"Fred"}, new String[]{"java.lang.String"});
            this.m_server.createMBean(ownerClassName, ownerName2, null, new Object[]{"Humpty Dumpty"}, new String[]{"java.lang.String"});
            System.out.println("----------------------- done ----------------------------");
            System.out.println("Build the roles");
            ArrayList<ObjectName> ownerList = new ArrayList<ObjectName>();
            ownerList.add(ownerName1);
            Role ownerRole = new Role("owner", ownerList);
            System.out.println("created owner Role");
            ArrayList<ObjectName> bookList = new ArrayList<ObjectName>();
            bookList.add(bookName1);
            bookList.add(bookName2);
            bookList.add(bookName3);
            Role bookRole = new Role("books", bookList);
            System.out.println("Created book role");
            System.out.println("----------------------- done ----------------------------");
            System.out.println("Creating the relation");
            RoleList libraryList = new RoleList();
            libraryList.add(ownerRole);
            libraryList.add(bookRole);
            this.createLibraryRelation(personalLibraryId, libraryTypeName, libraryList);
            System.out.println("Getting all the related info");
            this.printAllRelationInfo();
            System.out.println("----------------------- done ----------------------------");
            System.out.println("borrow a book we have 3 one more does not invalidate our relation");
            this.borrowBooks(personalLibraryId, "books", bookName4);
            ArrayList newBookList4 = this.getRoleValue(personalLibraryId, "books");
            System.out.println("we now have 4 books: " + newBookList4.toString());
            System.out.println("----------------------- done ----------------------------");
            System.out.println("2 MBeans removed from the MBeanServer - no problem we still have a valid relation.");
            this.m_server.unregisterMBean(bookName1);
            this.m_server.unregisterMBean(bookName2);
            ArrayList newBookList = this.getRoleValue(personalLibraryId, "books");
            System.out.println("After removing the 2 MBeans we have only 2 Book MBeans left " + newBookList.toString());
            System.out.println("----------------------- done ----------------------------");
            System.out.println("Deregistering the last of our books from the MBeanServer");
            this.m_server.unregisterMBean(bookName3);
            this.m_server.unregisterMBean(bookName4);
            System.out.println("----------------------- done ----------------------------");
            System.out.println("Testing access by running queries: ");
            System.out.println("The relation should have been removed and an exception of RelationNotFoundException returned");
            this.testAllAccessQueries(personalLibraryId);
            System.out.println("----------------------- done ----------------------------");
        }
        catch (Exception ex) {
            System.out.println("Could Not create the RelationService: " + ex);
            ex.printStackTrace();
        }
    }

    public void borrowBooks(String relationId, String roleName, ObjectName bookToAdd) {
        Logger logger = this.getLogger();
        try {
            ArrayList oldRoleValue = this.getRoleValue(relationId, roleName);
            ArrayList newRoleValue = (ArrayList)oldRoleValue.clone();
            newRoleValue.add(bookToAdd);
            Role role = new Role(roleName, newRoleValue);
            Object[] params1 = new Object[]{relationId, role};
            String[] signature1 = new String[]{"java.lang.String", "javax.management.relation.Role"};
            this.m_server.invoke(this.m_relationObjectName, "setRole", params1, signature1);
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to add a book");
            ex.printStackTrace();
        }
    }

    private void printList(List list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            System.out.println(">>>> Names representing roles: " + i.next());
        }
    }

    private ArrayList getRoleValue(String relationId, String roleName) {
        Logger logger = this.getLogger();
        try {
            Object[] params = new Object[]{relationId, roleName};
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            return (ArrayList)this.m_server.invoke(this.m_relationObjectName, "getRole", params, signature);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to get the list of roles for ID: " + relationId));
            return null;
        }
    }

    public void endExample() {
        try {
            System.out.println("Cleaning up......");
            Set<ObjectInstance> mbeanSet = this.m_server.queryMBeans(null, Query.initialSubString(Query.classattr(), Query.value("management*")));
            Iterator<ObjectInstance> i = mbeanSet.iterator();
            while (i.hasNext()) {
                this.m_server.unregisterMBean(i.next().getObjectName());
            }
            this.m_server.unregisterMBean(this.m_relationObjectName);
            MBeanServerFactory.releaseMBeanServer(this.m_server);
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void addRelationType() {
        try {
            Object[] params = new Object[]{this.m_library};
            String[] signature = new String[]{"javax.management.relation.RelationType"};
            this.m_server.invoke(this.m_relationObjectName, "addRelationType", params, signature);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void printRelationTypeInfo() {
        try {
            ArrayList relTypeNameList = (ArrayList)this.m_server.getAttribute(this.m_relationObjectName, "AllRelationTypeNames");
            System.out.println("The RelationType Names found in the RelationService: " + relTypeNameList.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createLibraryRelation(String personalLibraryId, String libraryTypeName, RoleList libraryList) {
        Logger logger = this.getLogger();
        try {
            Object[] params = new Object[]{personalLibraryId, libraryTypeName, libraryList};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "javax.management.relation.RoleList"};
            this.m_server.invoke(this.m_relationObjectName, "createRelation", params, signature);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception creating Library Relation: " + ex.getMessage()));
            ex.printStackTrace();
        }
    }

    private void printAllRelationInfo() {
        Logger logger = this.getLogger();
        try {
            ArrayList allRelationIds = (ArrayList)this.m_server.getAttribute(this.m_relationObjectName, "AllRelationIds");
            Iterator i = allRelationIds.iterator();
            while (i.hasNext()) {
                String currentRelationId = (String)i.next();
                System.out.println("All RelationIds: " + currentRelationId);
                this.testAllAccessQueries(currentRelationId);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to print the relations");
            ex.printStackTrace();
        }
    }

    private void testAllAccessQueries(String relationId) {
        Logger logger = this.getLogger();
        try {
            Object[] params = new Object[]{relationId};
            String[] signature = new String[]{"java.lang.String"};
            RoleResult roleResult = (RoleResult)this.m_server.invoke(this.m_relationObjectName, "getAllRoles", params, signature);
            RoleList roleList = roleResult.getRoles();
            Iterator i = roleList.iterator();
            while (i.hasNext()) {
                Role currentRole = (Role)i.next();
                System.out.println(">>>> role name: " + currentRole.getRoleName());
                System.out.println(">>>> role values: " + currentRole.getRoleValue().toString());
            }
            System.out.println("No unresolved Roles roleUnresolved size: " + roleResult.getRolesUnresolved().size());
        }
        catch (Exception ex) {
            logger.error((Object)("Exception printing the results from relationId: " + relationId));
            System.out.println("Printing the Exception message to validate exception: " + ex.getMessage());
        }
    }

    private Logger getLogger() {
        return Log.getLogger((String)this.getClass().getName());
    }

    public static void main(String[] args) {
        RelationServiceExample example = new RelationServiceExample();
        example.setUpRelations();
        example.endExample();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

