/*
 * Decompiled with CFR 0.152.
 */
package mx.wire4.webhook.verification.signature;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public final class UtilsCompute
implements Serializable {
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private static final String HMAC_SHA512 = "HmacSHA512";

    private UtilsCompute() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static byte[] computeHmacSha512(String message, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(DEFAULT_ENCODING), HMAC_SHA512);
        Mac mac = Mac.getInstance(HMAC_SHA512);
        mac.init(keySpec);
        return mac.doFinal(message.getBytes(DEFAULT_ENCODING));
    }

    private static String asHexString(byte[] hash) {
        return Hex.encodeHexString((byte[])hash);
    }

    public static boolean compareWebHookMsgSignatures(String message, String key, String headerSignature) throws InvalidKeyException {
        boolean result = false;
        try {
            byte[] hash = UtilsCompute.computeHmacSha512(message, key);
            String hashStr = UtilsCompute.asHexString(hash);
            result = MessageDigest.isEqual(hashStr.getBytes(DEFAULT_ENCODING), headerSignature.getBytes(DEFAULT_ENCODING));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return result;
    }
}

