/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Session;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.http.HtmlServiceWriter;
import org.codehaus.xfire.transport.local.LocalTransport;
import org.codehaus.xfire.util.STAXUtils;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.soap.xfire.XFireMuleSession;
import org.mule.providers.streaming.OutStreamMessageAdapter;
import org.mule.providers.streaming.StreamMessageAdapter;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Lifecycle;
import org.mule.umo.lifecycle.RecoverableException;

public class XFireServiceComponent
implements Callable,
Initialisable,
Lifecycle {
    public final String DEFAULT_CONTENT_TYPE = "text/html";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected XFire xfire;
    protected Transport transport = new LocalTransport();

    public Object onCall(UMOEventContext eventContext) throws Exception {
        String method;
        StreamMessageAdapter sma;
        UMOEndpointURI endpointURI = eventContext.getEndpointURI();
        OutStreamMessageAdapter response = eventContext.isStreaming() ? ((sma = (StreamMessageAdapter)eventContext.getMessage().getPayload()).getOutput() != null ? new OutStreamMessageAdapter((Object)sma.getOutput()) : new OutStreamMessageAdapter((Object)new ByteArrayOutputStream())) : new OutStreamMessageAdapter((Object)new ByteArrayOutputStream());
        UMOMessage eventMsg = eventContext.getMessage();
        String endpointHeader = eventMsg.getStringProperty("MULE_ENDPOINT", null);
        String request = eventMsg.getStringProperty("http.request", null);
        if (request != null) {
            endpointURI = new MuleEndpointURI("soap:" + endpointURI.toString() + request);
        }
        if ((method = endpointURI.getParams().getProperty("method")) == null) {
            method = eventMsg.getStringProperty("method", null);
        }
        if (method == null && endpointHeader != null) {
            endpointURI = new MuleEndpointURI(endpointHeader);
            method = endpointURI.getParams().getProperty("method");
        }
        if (method == null) {
            throw new MuleException(new Message(183, (Object)"method"));
        }
        String serviceName = this.getService(eventContext);
        if (request == null) {
            request = endpointHeader;
        }
        if (request != null && request.endsWith("?wsdl")) {
            this.generateWSDL(response, serviceName);
        }
        ServiceRegistry reg = this.getServiceRegistry();
        if (serviceName == null || serviceName.length() == 0 || !reg.hasService(serviceName)) {
            if (!reg.hasService(serviceName)) {
                eventMsg.setProperty((Object)"http.status", (Object)String.valueOf(404));
            }
            this.generateServices(response);
            return response;
        }
        this.invoke(eventContext, endpointURI, response, serviceName, method);
        return response.getPayloadAsBytes();
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void initialise() throws InitialisationException, RecoverableException {
        if (this.xfire == null) {
            throw new InitialisationException(new Message(45, (Object)"xfire"), (Object)this);
        }
    }

    public void dispose() {
    }

    protected void registerTransport() {
        TransportManager transportManager = this.getTransportManager();
        transportManager.register(this.transport);
    }

    protected TransportManager getTransportManager() {
        return this.getXfire().getTransportManager();
    }

    protected void generateService(OutStreamMessageAdapter response, String serviceName) throws IOException, XMLStreamException {
        response.setProperty((Object)"Content-Type", (Object)"text/html");
        Service endpoint = this.getServiceRegistry().getService(serviceName);
        HtmlServiceWriter writer = new HtmlServiceWriter();
        writer.write(response.getStream(), endpoint);
    }

    protected void generateServices(OutStreamMessageAdapter response) throws IOException, XMLStreamException {
        response.setProperty((Object)"Content-Type", (Object)"text/html");
        HtmlServiceWriter writer = new HtmlServiceWriter();
        writer.write(response.getStream(), this.getServiceRegistry().getServices());
    }

    protected void invoke(UMOEventContext eventContext, UMOEndpointURI endpointURI, OutStreamMessageAdapter response, String service, String methodName) throws IOException, UnsupportedEncodingException, UMOException, MessagingException, NoSuchMethodException {
        Channel channel;
        MessageContext context = new MessageContext();
        context.setXFire(this.xfire);
        XFireMuleSession session = new XFireMuleSession(eventContext.getSession());
        context.setSession((Session)session);
        context.setService(this.getService(service));
        OperationInfo op = context.getService().getServiceInfo().getOperation(methodName);
        if (op == null) {
            throw new NoSuchMethodException(methodName);
        }
        context.setExchange(new MessageExchange(context));
        context.getExchange().setOperation(op);
        String uri = endpointURI.toString();
        try {
            channel = this.transport.createChannel(uri);
        }
        catch (Exception e) {
            this.logger.debug((Object)"Couldn't open channel.", (Throwable)e);
            throw new org.mule.umo.MessagingException(new Message("xfire", 7, (Object)uri), eventContext.getMessage(), (Throwable)e);
        }
        UMOMessage eventMsg = eventContext.getMessage();
        String encoding = eventMsg.getStringProperty("Content-Encoding", MuleManager.getConfiguration().getEncoding());
        String contentType = eventMsg.getStringProperty("Content-Type", null);
        if (contentType == null) {
            contentType = "text/html; charset=" + encoding;
            this.logger.warn((Object)("Content-Type not set on request, defaulting to: " + contentType));
        } else if (contentType.indexOf("charset=") == -1) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (contentType.toLowerCase().indexOf("multipart/related") != -1) {
            try {
                JavaMailAttachments atts = new JavaMailAttachments(this.getMessageStream(eventContext), contentType);
                XMLStreamReader reader = STAXUtils.createXMLStreamReader((InputStream)atts.getSoapMessage().getDataHandler().getInputStream(), (String)encoding, (MessageContext)context);
                InMessage message = new InMessage(reader, uri);
                message.setProperty((Object)"SOAPAction", (Object)eventMsg.getStringProperty("SOAPAction", ""));
                message.setAttachments((Attachments)atts);
                context.getExchange().setInMessage(message);
                context.setCurrentMessage((AbstractMessage)message);
                context.setProperty("urn:xfire:channel:backchannel", (Object)response.getStream());
                channel.receive(context, message);
            }
            catch (MessagingException e) {
                throw new XFireRuntimeException("Couldn't parse request message.", (Throwable)e);
            }
        } else {
            XMLStreamReader reader = STAXUtils.createXMLStreamReader((InputStream)this.getMessageStream(eventContext), (String)encoding, (MessageContext)context);
            InMessage message = new InMessage(reader, uri);
            context.getExchange().setInMessage(message);
            context.setCurrentMessage((AbstractMessage)message);
            context.setProperty("urn:xfire:channel:backchannel", (Object)response.getStream());
            channel.receive(context, message);
        }
    }

    protected InputStream getMessageStream(UMOEventContext context) throws UMOException {
        StreamMessageAdapter sma;
        UMOMessage eventMsg = context.getMessage();
        Object eventMsgPayload = eventMsg.getPayload();
        InputStream is = eventMsgPayload instanceof InputStream ? (InputStream)eventMsgPayload : (eventMsg.getAdapter() instanceof StreamMessageAdapter ? ((sma = (StreamMessageAdapter)eventMsg.getAdapter()).getInput() != null ? sma.getInput() : sma.getResponse()) : new ByteArrayInputStream(context.getTransformedMessageAsBytes()));
        return is;
    }

    protected void generateWSDL(OutStreamMessageAdapter response, String service) throws IOException {
        response.setProperty((Object)"Content-Type", (Object)"text/xml");
        this.getXfire().generateWSDL(service, response.getStream());
    }

    protected String getService(UMOEventContext context) {
        String pathInfo = context.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)pathInfo)) {
            return context.getEndpointURI().getHost();
        }
        int i = pathInfo.lastIndexOf("/");
        String serviceName = i > -1 ? pathInfo.substring(i + 1) : pathInfo;
        return serviceName;
    }

    protected Service getService(String name) {
        return this.getXfire().getServiceRegistry().getService(name);
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire xfire) {
        this.xfire = xfire;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.xfire.getServiceRegistry();
    }
}

