/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.xfire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import org.apache.commons.lang.StringUtils;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.soap.xfire.MuleHeadersInHandler;
import org.mule.providers.soap.xfire.MuleHeadersOutHandler;
import org.mule.providers.soap.xfire.XFireConnector;
import org.mule.providers.soap.xfire.transport.MuleUniversalTransport;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.transformer.TransformerException;

public class XFireMessageDispatcher
extends AbstractMessageDispatcher {
    protected XFireConnector connector;
    protected Client client;

    public XFireMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (XFireConnector)endpoint.getConnector();
    }

    protected void doConnect(UMOImmutableEndpoint endpoint) throws Exception {
        if (this.client == null) {
            String serviceName = this.getService(endpoint);
            XFire xfire = this.connector.getXfire();
            Service service = xfire.getServiceRegistry().getService(serviceName);
            this.client = new Client((Transport)new MuleUniversalTransport(), service, endpoint.getEndpointURI().toString());
            this.client.setXFire(xfire);
            this.client.setEndpointUri(endpoint.getEndpointURI().toString());
            this.client.addInHandler((Handler)new MuleHeadersInHandler());
            this.client.addOutHandler((Handler)new MuleHeadersOutHandler());
        }
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    protected void doDispose() {
    }

    protected String getMethod(UMOEvent event) throws DispatchException {
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        String method = (String)endpointUri.getParams().remove("method");
        if (method == null && (method = (String)event.getEndpoint().getProperties().get("method")) == null) {
            throw new DispatchException(new Message("soap", 4), event.getMessage(), event.getEndpoint());
        }
        return method;
    }

    protected Object[] getArgs(UMOEvent event) throws TransformerException {
        Object payload = event.getTransformedMessage();
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        if (event.getMessage().getAttachmentNames() != null && event.getMessage().getAttachmentNames().size() > 0) {
            ArrayList<DataHandler> attachments = new ArrayList<DataHandler>();
            Iterator i = event.getMessage().getAttachmentNames().iterator();
            while (i.hasNext()) {
                attachments.add(event.getMessage().getAttachment((String)i.next()));
            }
            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(args));
            temp.add(attachments.toArray(new DataHandler[0]));
            args = temp.toArray();
        }
        return args;
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        if (this.client.getTimeout() != event.getTimeout()) {
            this.client.setTimeout(event.getTimeout());
        }
        this.client.setProperty("MULE_EVENT", (Object)event);
        String method = this.getMethod(event);
        Object[] response = this.client.invoke(method, this.getArgs(event));
        MuleMessage result = null;
        if (response != null && response.length <= 1) {
            if (response.length == 1) {
                result = new MuleMessage(response[0], (UMOMessageAdapter)event.getMessage());
            }
        } else {
            result = new MuleMessage((Object)response, (UMOMessageAdapter)event.getMessage());
        }
        return result;
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        if (this.client.getTimeout() != event.getTimeout()) {
            this.client.setTimeout(event.getTimeout());
        }
        this.client.setProperty("MULE_EVENT", (Object)event);
        String method = this.getMethod(event);
        this.client.invoke(method, this.getArgs(event));
    }

    protected UMOMessage doReceive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        String serviceName = this.getService(endpoint);
        XFire xfire = this.connector.getXfire();
        Service service = xfire.getServiceRegistry().getService(serviceName);
        Client client = new Client((Transport)new MuleUniversalTransport(), service, endpoint.getEndpointURI().toString());
        client.setXFire(xfire);
        client.setTimeout((int)timeout);
        client.setEndpointUri(endpoint.getEndpointURI().toString());
        String method = (String)endpoint.getProperty((Object)"method");
        OperationInfo op = service.getServiceInfo().getOperation(method);
        Properties params = endpoint.getEndpointURI().getUserParams();
        Object[] args = new String[params.size()];
        int i = 0;
        Iterator<Object> iterator = params.values().iterator();
        while (iterator.hasNext()) {
            args[i] = iterator.next().toString();
            ++i;
        }
        Object[] response = client.invoke(op, args);
        if (response != null && response.length == 1) {
            return new MuleMessage(response[0]);
        }
        return new MuleMessage((Object)response);
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    protected String getService(UMOImmutableEndpoint endpoint) {
        String pathInfo = endpoint.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)pathInfo)) {
            return endpoint.getEndpointURI().getHost();
        }
        int i = pathInfo.lastIndexOf("/");
        String serviceName = i > -1 ? pathInfo.substring(i + 1) : pathInfo;
        return serviceName;
    }
}

