/*
 * Decompiled with CFR 0.152.
 */
package me.rosuh.filepicker.engine;

import android.content.Context;
import android.util.Log;
import android.widget.ImageView;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import me.rosuh.filepicker.R;
import me.rosuh.filepicker.config.FilePickerManager;
import me.rosuh.filepicker.engine.GlideEngine;
import me.rosuh.filepicker.engine.ImageEngine;
import me.rosuh.filepicker.engine.ImageLoadController;
import me.rosuh.filepicker.engine.PicassoEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0002J/\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u0010R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/rosuh/filepicker/engine/ImageLoadController;", "", "()V", "enableGlide", "", "getEnableGlide", "()Z", "enableGlide$delegate", "Lkotlin/Lazy;", "enablePicasso", "getEnablePicasso", "enablePicasso$delegate", "engine", "Lme/rosuh/filepicker/engine/ImageEngine;", "initEngine", "load", "", "context", "Landroid/content/Context;", "iv", "Landroid/widget/ImageView;", "url", "", "placeholder", "", "(Landroid/content/Context;Landroid/widget/ImageView;Ljava/lang/String;Ljava/lang/Integer;)V", "reset", "filepicker_release"})
public final class ImageLoadController {
    @NotNull
    public static final ImageLoadController INSTANCE = new ImageLoadController();
    @NotNull
    private static final Lazy enableGlide$delegate = LazyKt.lazy((Function0)enableGlide.2.INSTANCE);
    @NotNull
    private static final Lazy enablePicasso$delegate = LazyKt.lazy((Function0)enablePicasso.2.INSTANCE);
    @Nullable
    private static ImageEngine engine;

    private ImageLoadController() {
    }

    private final boolean getEnableGlide() {
        Lazy lazy = enableGlide$delegate;
        return (Boolean)lazy.getValue();
    }

    private final boolean getEnablePicasso() {
        Lazy lazy = enablePicasso$delegate;
        return (Boolean)lazy.getValue();
    }

    public final void load(@NotNull Context context, @NotNull ImageView iv, @NotNull String url, @Nullable Integer placeholder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (engine == null && !this.initEngine()) {
            Integer n = placeholder;
            iv.setImageResource(n == null ? R.drawable.ic_unknown_file_picker : n);
            return;
        }
        try {
            ImageEngine imageEngine = engine;
            if (imageEngine != null) {
                Integer n = placeholder;
                imageEngine.loadImage(context, iv, url, n == null ? R.drawable.ic_unknown_file_picker : n);
            }
        }
        catch (NoSuchMethodError e) {
            Log.d((String)"ImageLoadController", (String)"AndroidFilePicker throw NoSuchMethodError which means current Glide version was not supported. \nWe recommend using 4.9+ or you should implements your own ImageEngine.\nRef:https://github.com/rosuH/AndroidFilePicker/issues/76");
            Integer n = placeholder;
            iv.setImageResource(n == null ? R.drawable.ic_unknown_file_picker : n);
        }
    }

    public static /* synthetic */ void load$default(ImageLoadController imageLoadController, Context context, ImageView imageView, String string, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = R.drawable.ic_unknown_file_picker;
        }
        imageLoadController.load(context, imageView, string, n);
    }

    private final boolean initEngine() {
        engine = FilePickerManager.INSTANCE.getConfig$filepicker_release().getCustomImageEngine() != null ? FilePickerManager.INSTANCE.getConfig$filepicker_release().getCustomImageEngine() : (this.getEnableGlide() ? (ImageEngine)new GlideEngine() : (this.getEnablePicasso() ? (ImageEngine)new PicassoEngine() : (ImageEngine)null));
        return engine != null;
    }

    public final void reset() {
        engine = null;
    }
}

