/*
 * Decompiled with CFR 0.152.
 */
package me.relex.circleindicator;

import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import java.util.List;
import me.relex.circleindicator.CircleIndicator;

public class SnackbarBehavior
extends CoordinatorLayout.Behavior<CircleIndicator> {
    public SnackbarBehavior() {
    }

    public SnackbarBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, CircleIndicator child, View dependency) {
        return dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, CircleIndicator child, View dependency) {
        float translationY = this.getTranslationYForSnackbar(parent, child);
        child.setTranslationY(translationY);
        return true;
    }

    private float getTranslationYForSnackbar(CoordinatorLayout parent, CircleIndicator ci) {
        float minOffset = 0.0f;
        List dependencies = parent.getDependencies((View)ci);
        int z = dependencies.size();
        for (int i = 0; i < z; ++i) {
            View view = (View)dependencies.get(i);
            if (!(view instanceof Snackbar.SnackbarLayout) || !parent.doViewsOverlap((View)ci, view)) continue;
            minOffset = Math.min(minOffset, ViewCompat.getTranslationY((View)view) - (float)view.getHeight());
        }
        return minOffset;
    }
}

