/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gradle.gitversioning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import me.qoomon.gitversioning.commons.GitRefType;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;

public class GitVersioningPluginConfig {
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    public Boolean disable = false;
    public String projectVersionPattern = null;
    public String describeTagPattern = null;
    public Boolean describeTagFirstParent = true;
    public Boolean updateGradleProperties;
    public final RefPatchDescriptionList refs = this.getObjectFactory() != null ? (RefPatchDescriptionList)this.getObjectFactory().newInstance(RefPatchDescriptionList.class, new Object[0]) : new RefPatchDescriptionList();
    public PatchDescription rev;

    @Inject
    protected ObjectFactory getObjectFactory() {
        return null;
    }

    public Pattern projectVersionPattern() {
        return this.projectVersionPattern != null ? Pattern.compile(this.projectVersionPattern) : null;
    }

    public void refs(Action<RefPatchDescriptionList> action) {
        action.execute((Object)this.refs);
    }

    public void rev(Action<PatchDescription> action) {
        this.rev = this.getObjectFactory() != null ? (PatchDescription)this.getObjectFactory().newInstance(PatchDescription.class, new Object[0]) : new PatchDescription();
        action.execute((Object)this.rev);
    }

    public static class RefPatchDescriptionList {
        public boolean considerTagsOnBranches = false;
        public List<RefPatchDescription> list = new ArrayList<RefPatchDescription>();

        public void branch(String pattern, Action<RefPatchDescription> action) {
            RefPatchDescription ref = new RefPatchDescription(GitRefType.BRANCH, Pattern.compile(pattern));
            action.execute((Object)ref);
            this.list.add(ref);
        }

        public void tag(String pattern, Action<RefPatchDescription> action) {
            RefPatchDescription ref = new RefPatchDescription(GitRefType.TAG, Pattern.compile(pattern));
            action.execute((Object)ref);
            this.list.add(ref);
        }
    }

    public static class PatchDescription {
        public String describeTagPattern;
        public Boolean describeTagFirstParent = null;
        public Boolean updateGradleProperties;
        public String version;
        public Map<String, String> properties = new HashMap<String, String>();

        public Pattern getDescribeTagPattern() {
            return Pattern.compile(this.describeTagPattern);
        }

        public Map<String, String> getProperties_() {
            return this.properties;
        }

        public void setProperties_(Map<String, String> properties) {
            this.properties = properties;
        }
    }

    public static class RefPatchDescription
    extends PatchDescription {
        public final GitRefType type;
        public final Pattern pattern;

        public RefPatchDescription(GitRefType type, Pattern pattern) {
            this.type = type;
            this.pattern = pattern;
        }

        public RefPatchDescription(GitRefType type, Pattern pattern, PatchDescription patch) {
            this(type, pattern);
            this.describeTagPattern = patch.describeTagPattern;
            this.describeTagFirstParent = patch.describeTagFirstParent;
            this.updateGradleProperties = patch.updateGradleProperties;
            this.version = patch.version;
            this.properties = patch.properties;
        }
    }
}

