/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gradle.gitversioning;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.qoomon.gitversioning.commons.GitDescription;
import me.qoomon.gitversioning.commons.GitRefType;
import me.qoomon.gitversioning.commons.GitSituation;
import me.qoomon.gitversioning.commons.Lazy;
import me.qoomon.gitversioning.commons.StringUtil;
import me.qoomon.gradle.gitversioning.GitVersionDetails;
import me.qoomon.gradle.gitversioning.GitVersioningPluginConfig;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.util.ConfigureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitVersioningPluginExtension {
    public static final Logger LOGGER = LoggerFactory.getLogger(GitVersioningPluginExtension.class);
    private static final String OPTION_NAME_GIT_REF = "git.ref";
    private static final String OPTION_NAME_GIT_TAG = "git.tag";
    private static final String OPTION_NAME_GIT_BRANCH = "git.branch";
    private static final String OPTION_NAME_DISABLE = "versioning.disable";
    private static final String OPTION_UPDATE_GRADLE_PROPERTIES = "versioning.updateGradleProperties";
    public final Project rootProject;
    public GitVersionDetails gitVersionDetails;
    public Map<String, Supplier<String>> globalFormatPlaceholderMap;

    public GitVersioningPluginExtension(Project project) {
        this.rootProject = project;
    }

    public void apply(Closure<GitVersioningPluginConfig> closure) throws IOException {
        this.apply((GitVersioningPluginConfig)ConfigureUtil.configure(closure, (Object)new GitVersioningPluginConfig()));
    }

    public void apply(Action<GitVersioningPluginConfig> action) throws IOException {
        GitVersioningPluginConfig config = new GitVersioningPluginConfig();
        action.execute((Object)config);
        this.apply(config);
    }

    public void apply(GitVersioningPluginConfig config) throws IOException {
        boolean updateGradleProperties;
        GitSituation gitSituation;
        this.normalizeConfig(config);
        String commandOptionDisable = this.getCommandOption(OPTION_NAME_DISABLE);
        if (commandOptionDisable != null) {
            boolean disabled = Boolean.parseBoolean(commandOptionDisable);
            if (disabled) {
                LOGGER.info("skip - versioning is disabled by command option");
                return;
            }
        } else if (config.disable.booleanValue()) {
            LOGGER.info("skip - versioning is disabled by config option");
            return;
        }
        if ((gitSituation = this.getGitSituation(this.rootProject.getProjectDir())) == null) {
            LOGGER.warn("skip - project is not part of a git repository");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("git situation:");
            LOGGER.debug("  root directory: " + gitSituation.getRootDirectory());
            LOGGER.debug("  head commit: " + gitSituation.getRev());
            LOGGER.debug("  head commit timestamp: " + gitSituation.getTimestamp());
            LOGGER.debug("  head branch: " + gitSituation.getBranch());
            LOGGER.debug("  head tags: " + gitSituation.getTags());
            LOGGER.debug("  head description: " + gitSituation.getDescription());
        }
        this.gitVersionDetails = GitVersioningPluginExtension.getGitVersionDetails(gitSituation, config);
        if (this.gitVersionDetails == null) {
            LOGGER.warn("skip - no matching ref configuration and no rev configuration defined");
            LOGGER.warn("git refs:");
            LOGGER.warn("  branch: " + gitSituation.getBranch());
            LOGGER.warn("  tags: " + gitSituation.getTags());
            LOGGER.warn("defined ref configurations:");
            config.refs.list.forEach(ref -> LOGGER.warn("  " + StringUtils.rightPad((String)ref.type.name(), (int)6) + " - pattern: " + ref.pattern));
            return;
        }
        LOGGER.info("matching ref: " + this.gitVersionDetails.getRefType().name() + " - " + this.gitVersionDetails.getRefName());
        GitVersioningPluginConfig.RefPatchDescription patchDescription = this.gitVersionDetails.getPatchDescription();
        LOGGER.info("ref configuration: " + this.gitVersionDetails.getRefType().name() + " - pattern: " + patchDescription.pattern);
        if (patchDescription.describeTagPattern != null) {
            LOGGER.info("  describeTagPattern: " + patchDescription.describeTagPattern);
            gitSituation.setDescribeTagPattern(patchDescription.describeTagPattern);
        }
        if (patchDescription.version != null) {
            LOGGER.info("  version: " + patchDescription.version);
        }
        if (!patchDescription.properties.isEmpty()) {
            LOGGER.info("  properties: " + patchDescription.version);
            patchDescription.properties.forEach((key, value) -> LOGGER.info("    " + key + " - " + value));
        }
        if (updateGradleProperties = this.getUpdateGradlePropertiesOption(patchDescription)) {
            LOGGER.info("  updateGradleProperties: " + updateGradleProperties);
        }
        this.globalFormatPlaceholderMap = this.generateGlobalFormatPlaceholderMap(gitSituation, this.gitVersionDetails, this.rootProject);
        Map<String, String> gitProjectProperties = GitVersioningPluginExtension.generateGitProjectProperties(gitSituation, this.gitVersionDetails);
        this.rootProject.getAllprojects().forEach(project -> {
            File gradleProperties;
            Map propertyFormats;
            String originalProjectVersion = project.getVersion().toString();
            String versionFormat = patchDescription.version;
            if (versionFormat != null) {
                this.updateVersion((Project)project, versionFormat);
                LOGGER.info("project version: " + project.getVersion());
            }
            if ((propertyFormats = patchDescription.properties) != null && !propertyFormats.isEmpty()) {
                this.updatePropertyValues((Project)project, propertyFormats, originalProjectVersion);
            }
            this.addGitProjectProperties((Project)project, gitProjectProperties);
            if (updateGradleProperties && (gradleProperties = project.file((Object)"gradle.properties")).exists()) {
                this.updateGradlePropertiesFile(gradleProperties, (Project)project);
            }
        });
    }

    private void updateVersion(Project project, String versionFormat) {
        String gitProjectVersion = this.getGitVersion(versionFormat, project.getVersion().toString());
        project.getLogger().info("set version to  " + gitProjectVersion);
        project.setVersion((Object)gitProjectVersion);
    }

    private void updatePropertyValues(Project project, Map<String, String> propertyFormats, String originalProjectVersion) {
        boolean logHeader = true;
        for (Map.Entry projectProperty : project.getProperties().entrySet()) {
            String projectPropertyName = (String)projectProperty.getKey();
            Object projectPropertyValue = projectProperty.getValue();
            String propertyFormat = propertyFormats.get(projectPropertyName);
            if (propertyFormat == null) continue;
            if (projectPropertyValue == null || projectPropertyValue instanceof String) {
                String gitPropertyValue = this.getGitPropertyValue(propertyFormat, projectPropertyValue != null ? projectPropertyValue.toString() : null, originalProjectVersion);
                if (gitPropertyValue.equals(projectPropertyValue)) continue;
                if (logHeader) {
                    LOGGER.info("properties:");
                    logHeader = false;
                }
                LOGGER.info("set property " + projectPropertyName + " to " + gitPropertyValue);
                project.setProperty(projectPropertyName, (Object)gitPropertyValue);
                continue;
            }
            LOGGER.warn("Can not update property " + projectPropertyName + ". Expected value type is String, but was " + projectPropertyValue.getClass().getName());
        }
    }

    private void addGitProjectProperties(Project project, Map<String, String> gitProjectProperties) {
        ExtraPropertiesExtension extraProperties = project.getExtensions().getExtraProperties();
        gitProjectProperties.forEach((arg_0, arg_1) -> ((ExtraPropertiesExtension)extraProperties).set(arg_0, arg_1));
    }

    private void updateGradlePropertiesFile(File gradleProperties, Project project) {
        PropertiesConfiguration gradlePropertiesConfig = new PropertiesConfiguration();
        try (FileReader reader = new FileReader(gradleProperties);){
            gradlePropertiesConfig.read((Reader)reader);
        }
        catch (IOException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
        if (gradlePropertiesConfig.containsKey("version")) {
            Object gradlePropertyVersion = gradlePropertiesConfig.getProperty("version");
            Object projectVersion = project.getVersion();
            if (!Objects.equals(projectVersion, gradlePropertyVersion)) {
                gradlePropertiesConfig.setProperty("version", projectVersion);
            }
        }
        Map projectProperties = project.getProperties();
        this.gitVersionDetails.getPatchDescription().properties.forEach((key, value) -> {
            if (gradlePropertiesConfig.containsKey(key)) {
                Object gradlePropertyValue = gradlePropertiesConfig.getProperty(key);
                Object projectPropertyValue = projectProperties.get(key);
                if (!Objects.equals(projectPropertyValue, gradlePropertyValue)) {
                    gradlePropertiesConfig.setProperty(key, projectPropertyValue);
                }
            }
        });
        try (StringWriter writer = new StringWriter(512);){
            gradlePropertiesConfig.write((Writer)writer);
            byte[] gitVersionedGradlePropertiesBytes = writer.toString().getBytes();
            byte[] existingGradlePropertiesBytes = Files.readAllBytes(gradleProperties.toPath());
            if (!Arrays.equals(gitVersionedGradlePropertiesBytes, existingGradlePropertiesBytes)) {
                Files.write(gradleProperties.toPath(), gitVersionedGradlePropertiesBytes, new OpenOption[0]);
            }
        }
        catch (IOException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private GitSituation getGitSituation(File executionRootDirectory) throws IOException {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(executionRootDirectory);
        if (repositoryBuilder.getGitDir() == null) {
            return null;
        }
        Repository repository = repositoryBuilder.build();
        return new GitSituation(repository){
            {
                String jenkinsEnv;
                String circleciEnv;
                String commitTag;
                String commitBranch;
                String gitlabEnv;
                String githubEnv;
                String providedRef;
                super(repository);
                String overrideBranch = GitVersioningPluginExtension.this.getCommandOption(GitVersioningPluginExtension.OPTION_NAME_GIT_BRANCH);
                String overrideTag = GitVersioningPluginExtension.this.getCommandOption(GitVersioningPluginExtension.OPTION_NAME_GIT_TAG);
                if (overrideBranch == null && overrideTag == null && (providedRef = GitVersioningPluginExtension.this.getCommandOption(GitVersioningPluginExtension.OPTION_NAME_GIT_REF)) != null) {
                    if (!providedRef.startsWith("refs/")) {
                        throw new IllegalArgumentException("invalid provided ref " + providedRef + " -  needs to start with refs/");
                    }
                    if (providedRef.startsWith("refs/tags/")) {
                        overrideTag = providedRef;
                        overrideBranch = "";
                    } else {
                        overrideBranch = providedRef;
                        overrideTag = "";
                    }
                }
                if (overrideBranch == null && overrideTag == null && (githubEnv = System.getenv("GITHUB_ACTIONS")) != null && githubEnv.equals("true")) {
                    LOGGER.info("gather git situation from GitHub Actions environment variable: GITHUB_REF");
                    String githubRef = System.getenv("GITHUB_REF");
                    LOGGER.debug("  GITHUB_REF: " + githubRef);
                    if (githubRef != null && githubRef.startsWith("refs/")) {
                        if (githubRef.startsWith("refs/tags/")) {
                            overrideTag = githubRef;
                            overrideBranch = "";
                        } else {
                            overrideBranch = githubRef;
                            overrideTag = "";
                        }
                    }
                }
                if (overrideBranch == null && overrideTag == null && (gitlabEnv = System.getenv("GITLAB_CI")) != null && gitlabEnv.equals("true")) {
                    LOGGER.info("gather git situation from GitLab CI environment variables: CI_COMMIT_BRANCH and CI_COMMIT_TAG");
                    commitBranch = System.getenv("CI_COMMIT_BRANCH");
                    commitTag = System.getenv("CI_COMMIT_TAG");
                    LOGGER.debug("  CI_COMMIT_BRANCH: " + commitBranch);
                    LOGGER.debug("  CI_COMMIT_TAG: " + commitTag);
                    overrideBranch = commitBranch;
                    overrideTag = commitTag;
                }
                if (overrideBranch == null && overrideTag == null && (circleciEnv = System.getenv("CIRCLECI")) != null && circleciEnv.equals("true")) {
                    LOGGER.info("gather git situation from Circle CI environment variables: CIRCLE_BRANCH and CIRCLE_TAG");
                    commitBranch = System.getenv("CIRCLE_BRANCH");
                    commitTag = System.getenv("CIRCLE_TAG");
                    LOGGER.debug("  CIRCLE_BRANCH: " + commitBranch);
                    LOGGER.debug("  CIRCLE_TAG: " + commitTag);
                    overrideBranch = System.getenv("CIRCLE_BRANCH");
                    overrideTag = System.getenv("CIRCLE_TAG");
                }
                if (overrideBranch == null && overrideTag == null && (jenkinsEnv = System.getenv("JENKINS_HOME")) != null && !jenkinsEnv.trim().isEmpty()) {
                    LOGGER.info("gather git situation from jenkins environment variables: BRANCH_NAME and TAG_NAME");
                    String branchName = System.getenv("BRANCH_NAME");
                    String tagName = System.getenv("TAG_NAME");
                    LOGGER.debug("  BRANCH_NAME: " + branchName);
                    LOGGER.debug("  TAG_NAME: " + tagName);
                    if (branchName != null && branchName.equals(tagName)) {
                        overrideTag = tagName;
                        overrideBranch = "";
                    } else {
                        overrideBranch = branchName;
                        overrideTag = tagName;
                    }
                }
                if (overrideBranch != null || overrideTag != null) {
                    this.overrideBranch(overrideBranch);
                    this.overrideTags(overrideTag);
                }
            }

            void overrideBranch(String branch) {
                if (branch != null && branch.trim().isEmpty()) {
                    branch = null;
                }
                if (branch != null) {
                    if (branch.startsWith("refs/tags/")) {
                        throw new IllegalArgumentException("invalid branch ref" + branch);
                    }
                    branch = branch.replaceFirst("^refs/", "").replaceFirst("^heads/", "");
                }
                LOGGER.debug("override git branch with: " + branch);
                this.setBranch(branch);
            }

            void overrideTags(String tag) {
                if (tag != null && tag.trim().isEmpty()) {
                    tag = null;
                }
                if (tag != null) {
                    if (tag.startsWith("refs/") && !tag.startsWith("refs/tags/")) {
                        throw new IllegalArgumentException("invalid tag ref" + tag);
                    }
                    tag = tag.replaceFirst("^refs/tags/", "");
                }
                LOGGER.debug("override git tags with: " + tag);
                this.setTags(tag == null ? Collections.emptyList() : Collections.singletonList(tag));
            }
        };
    }

    private static GitVersionDetails getGitVersionDetails(GitSituation gitSituation, GitVersioningPluginConfig config) {
        Lazy<List> sortedTags = Lazy.by(() -> gitSituation.getTags().stream().sorted(Comparator.comparing(DefaultArtifactVersion::new)).collect(Collectors.toList()));
        block4: for (GitVersioningPluginConfig.RefPatchDescription refConfig : config.refs.list) {
            switch (refConfig.type) {
                case TAG: {
                    if (!gitSituation.isDetached() && !config.refs.considerTagsOnBranches) continue block4;
                    for (String tag : sortedTags.get()) {
                        if (refConfig.pattern != null && !refConfig.pattern.matcher(tag).matches()) continue;
                        return new GitVersionDetails(gitSituation.getRev(), GitRefType.TAG, tag, refConfig);
                    }
                    continue block4;
                }
                case BRANCH: {
                    if (gitSituation.isDetached()) continue block4;
                    String branch = gitSituation.getBranch();
                    if (refConfig.pattern != null && !refConfig.pattern.matcher(branch).matches()) continue block4;
                    return new GitVersionDetails(gitSituation.getRev(), GitRefType.BRANCH, branch, refConfig);
                }
                default: {
                    throw new IllegalArgumentException("Unexpected ref type: " + (Object)((Object)refConfig.type));
                }
            }
        }
        if (config.rev != null) {
            return new GitVersionDetails(gitSituation.getRev(), GitRefType.COMMIT, gitSituation.getRev(), new GitVersioningPluginConfig.RefPatchDescription(GitRefType.COMMIT, null, config.rev));
        }
        return null;
    }

    private String getGitVersion(String versionFormat, String originalProjectVersion) {
        Map<String, Supplier<String>> placeholderMap = this.generateFormatPlaceholderMap(originalProjectVersion);
        return GitVersioningPluginExtension.slugify(StringUtil.substituteText(versionFormat, placeholderMap));
    }

    private String getGitPropertyValue(String propertyFormat, String originalValue, String originalProjectVersion) {
        Map<String, Supplier<String>> placeholderMap = this.generateFormatPlaceholderMap(originalProjectVersion);
        placeholderMap.put("value", () -> originalValue);
        return StringUtil.substituteText(propertyFormat, placeholderMap);
    }

    private Map<String, Supplier<String>> generateFormatPlaceholderMap(String originalProjectVersion) {
        HashMap<String, Supplier<String>> placeholderMap = new HashMap<String, Supplier<String>>(this.globalFormatPlaceholderMap);
        placeholderMap.put("version", Lazy.of(originalProjectVersion));
        placeholderMap.put("version.release", Lazy.by(() -> originalProjectVersion.replaceFirst("-SNAPSHOT$", "")));
        return placeholderMap;
    }

    private Map<String, Supplier<String>> generateGlobalFormatPlaceholderMap(GitSituation gitSituation, GitVersionDetails gitVersionDetails, Project rootProject) {
        HashMap<String, Supplier<String>> placeholderMap = new HashMap<String, Supplier<String>>();
        Lazy<String> hash = Lazy.by(gitSituation::getRev);
        placeholderMap.put("commit", hash);
        placeholderMap.put("commit.short", Lazy.by(() -> ((String)hash.get()).substring(0, 7)));
        Lazy<ZonedDateTime> headCommitDateTime = Lazy.by(gitSituation::getTimestamp);
        placeholderMap.put("commit.timestamp", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).toEpochSecond())));
        placeholderMap.put("commit.timestamp.year", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getYear())));
        placeholderMap.put("commit.timestamp.year.2digit", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getYear() % 100)));
        placeholderMap.put("commit.timestamp.month", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getMonthValue()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.day", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getDayOfMonth()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.hour", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getHour()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.minute", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getMinute()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.second", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getSecond()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.datetime", Lazy.by(() -> ((ZonedDateTime)headCommitDateTime.get()).toEpochSecond() > 0L ? ((ZonedDateTime)headCommitDateTime.get()).format(DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss")) : "00000000.000000"));
        String refName = gitVersionDetails.getRefName();
        Lazy<String> refNameSlug = Lazy.by(() -> GitVersioningPluginExtension.slugify(refName));
        placeholderMap.put("ref", () -> refName);
        placeholderMap.put("ref.slug", refNameSlug);
        Pattern refPattern = gitVersionDetails.getPatchDescription().pattern;
        if (refPattern != null) {
            for (Map.Entry<String, String> patternGroup : StringUtil.patternGroupValues(refPattern, refName).entrySet()) {
                String groupName = patternGroup.getKey();
                String value2 = patternGroup.getValue() != null ? patternGroup.getValue() : "";
                placeholderMap.put("ref." + groupName, () -> value2);
                placeholderMap.put("ref." + groupName + ".slug", Lazy.by(() -> GitVersioningPluginExtension.slugify(value2)));
            }
        }
        Lazy<Boolean> dirty = Lazy.by(() -> !gitSituation.isClean());
        placeholderMap.put("dirty", Lazy.by(() -> (Boolean)dirty.get() != false ? "-DIRTY" : ""));
        placeholderMap.put("dirty.snapshot", Lazy.by(() -> (Boolean)dirty.get() != false ? "-SNAPSHOT" : ""));
        Lazy<GitDescription> description = Lazy.by(gitSituation::getDescription);
        placeholderMap.put("describe", Lazy.by(() -> ((GitDescription)description.get()).toString()));
        Lazy<String> descriptionTag = Lazy.by(() -> ((GitDescription)description.get()).getTag());
        placeholderMap.put("describe.tag", descriptionTag);
        placeholderMap.put("describe.distance", Lazy.by(() -> String.valueOf(((GitDescription)description.get()).getDistance())));
        Lazy<Map> describeTagPatternValues = Lazy.by(() -> StringUtil.patternGroupValues(gitSituation.getDescribeTagPattern(), (String)descriptionTag.get()));
        for (String string : StringUtil.patternGroups(gitSituation.getDescribeTagPattern())) {
            Lazy<String> value3 = Lazy.by(() -> (String)((Map)describeTagPatternValues.get()).get(groupName));
            placeholderMap.put("describe.tag." + string, value3);
            placeholderMap.put("describe.tag." + string + ".slug", Lazy.by(() -> GitVersioningPluginExtension.slugify((String)value3.get())));
        }
        for (Map.Entry entry : rootProject.getProperties().entrySet()) {
            if (entry.getValue() == null || !(entry.getValue() instanceof String) && !(entry.getValue() instanceof Number)) continue;
            placeholderMap.put("property." + (String)entry.getKey(), () -> property.getValue().toString());
        }
        System.getenv().forEach((key, value) -> placeholderMap.put("env." + key, () -> value));
        return placeholderMap;
    }

    private static Map<String, String> generateGitProjectProperties(GitSituation gitSituation, GitVersionDetails gitVersionDetails) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("git.commit", gitVersionDetails.getCommit());
        properties.put("git.commit.short", gitVersionDetails.getCommit().substring(0, 7));
        ZonedDateTime headCommitDateTime = gitSituation.getTimestamp();
        properties.put("git.commit.timestamp", String.valueOf(headCommitDateTime.toEpochSecond()));
        properties.put("git.commit.timestamp.datetime", headCommitDateTime.toEpochSecond() > 0L ? headCommitDateTime.format(DateTimeFormatter.ISO_INSTANT) : "0000-00-00T00:00:00Z");
        String refName = gitVersionDetails.getRefName();
        String refNameSlug = GitVersioningPluginExtension.slugify(refName);
        properties.put(OPTION_NAME_GIT_REF, refName);
        properties.put("git.ref.slug", refNameSlug);
        return properties;
    }

    private void normalizeConfig(GitVersioningPluginConfig config) {
        ArrayList<GitVersioningPluginConfig.RefPatchDescription> patchDescriptions = new ArrayList<GitVersioningPluginConfig.RefPatchDescription>(config.refs.list);
        if (config.rev != null) {
            patchDescriptions.add((GitVersioningPluginConfig.RefPatchDescription)config.rev);
        }
        for (GitVersioningPluginConfig.PatchDescription patchDescription : patchDescriptions) {
            if (patchDescription.describeTagPattern == null) {
                patchDescription.describeTagPattern = config.describeTagPattern;
            }
            if (patchDescription.updateGradleProperties != null) continue;
            patchDescription.updateGradleProperties = config.updateGradleProperties;
        }
    }

    private String getCommandOption(String name) {
        String value = (String)this.rootProject.getProperties().get(name);
        if (value == null) {
            String plainName = name.replaceFirst("^versioning\\.", "");
            String environmentVariableName = "VERSIONING_" + String.join((CharSequence)"_", plainName.split("(?=\\p{Lu})")).replaceAll("\\.", "_").toUpperCase();
            value = System.getenv(environmentVariableName);
        }
        if (value == null) {
            value = System.getProperty(name);
        }
        return value;
    }

    private boolean getUpdateGradlePropertiesOption(GitVersioningPluginConfig.RefPatchDescription gitRefConfig) {
        String updateGradlePropertiesOption = this.getCommandOption(OPTION_UPDATE_GRADLE_PROPERTIES);
        if (updateGradlePropertiesOption != null) {
            return Boolean.parseBoolean(updateGradlePropertiesOption);
        }
        if (gitRefConfig.updateGradleProperties != null) {
            return gitRefConfig.updateGradleProperties;
        }
        return false;
    }

    private static String slugify(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("/", "-");
    }
}

